/*
 * Decompiled with CFR 0.152.
 */
package com.github.fppt.jedismock.operations;

import com.github.fppt.jedismock.operations.AbstractRedisOperation;
import com.github.fppt.jedismock.server.Response;
import com.github.fppt.jedismock.server.Slice;
import com.github.fppt.jedismock.storage.OperationExecutorState;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RO_unsubscribe
extends AbstractRedisOperation {
    private static final Logger LOG = LoggerFactory.getLogger(RO_unsubscribe.class);
    private OperationExecutorState state;

    public RO_unsubscribe(OperationExecutorState state, List<Slice> params) {
        super(state.base(), params);
        this.state = state;
    }

    @Override
    Slice response() {
        List<Slice> channelsToUbsubscribeFrom;
        if (this.params().isEmpty()) {
            LOG.debug("No channels specified therefore unsubscribing from all channels");
            channelsToUbsubscribeFrom = this.base().getSubscriptions(this.state.owner());
        } else {
            channelsToUbsubscribeFrom = this.params();
        }
        for (Slice channel : channelsToUbsubscribeFrom) {
            LOG.debug("Unsubscribing from channel [" + channel + "]");
            if (!this.base().removeSubscriber(channel, this.state.owner())) continue;
            int numSubscriptions = this.base().getSubscriptions(this.state.owner()).size();
            Slice response = Response.unsubscribe(channel, numSubscriptions);
            this.state.owner().sendResponse(Response.clientResponse("unsubscribe", response), "unsubscribe");
        }
        return Response.SKIP;
    }
}

