/*
 * Decompiled with CFR 0.152.
 */
package com.buession.springcloud.fegin.interceptor;

import com.buession.core.utils.VersionUtils;
import com.buession.springcloud.common.Version;
import feign.Feign;
import feign.RequestInterceptor;
import feign.RequestTemplate;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

public class ClientHeadersRequestInterceptor
implements RequestInterceptor {
    private static final String REQUEST_CONTEXT_CLIENT_NAME = "X-Request-Context-Client";
    private static final String BUESSION_CLOUD_NAME = "X-Buession-Cloud-Version";
    private static final List<String> IGNORE_REQUEST_HEADERS = Arrays.asList("Accept-Encoding");
    private static final String REQUEST_CONTEXT_CLIENT = Feign.class.getSimpleName() + "/" + VersionUtils.determineClassVersion(Feign.class);
    private static final Logger logger = LoggerFactory.getLogger(ClientHeadersRequestInterceptor.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void apply(RequestTemplate requestTemplate) {
        try {
            ServletRequestAttributes attributes = (ServletRequestAttributes)RequestContextHolder.currentRequestAttributes();
            HttpServletRequest request = attributes.getRequest();
            Enumeration headerNames = request.getHeaderNames();
            while (headerNames != null && headerNames.hasMoreElements()) {
                String name = (String)headerNames.nextElement();
                if (IGNORE_REQUEST_HEADERS.contains(name)) {
                    logger.debug("Ignore feign request header, name: {}", (Object)name);
                    continue;
                }
                String value = request.getHeader(name);
                requestTemplate.header(name, new String[]{value});
                logger.debug("Add feign request header, name: {}, values: {}", (Object)name, (Object)value);
            }
        }
        catch (IllegalStateException e) {
            logger.error(e.getMessage());
        }
        finally {
            ClientHeadersRequestInterceptor.setRequestHeaders(requestTemplate);
        }
    }

    private static void setRequestHeaders(RequestTemplate requestTemplate) {
        requestTemplate.header(REQUEST_CONTEXT_CLIENT_NAME, new String[]{REQUEST_CONTEXT_CLIENT});
        requestTemplate.header(BUESSION_CLOUD_NAME, new String[]{Version.VERSION});
    }
}

