/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.otter.canal.client.impl;

import com.alibaba.otter.canal.client.CanalNodeAccessStrategy;
import com.alibaba.otter.canal.client.impl.ServerNotFoundException;
import com.alibaba.otter.canal.common.utils.JsonUtils;
import com.alibaba.otter.canal.common.zookeeper.ZkClientx;
import com.alibaba.otter.canal.common.zookeeper.ZookeeperPathUtils;
import com.alibaba.otter.canal.common.zookeeper.running.ServerRunningData;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.I0Itec.zkclient.IZkChildListener;
import org.I0Itec.zkclient.IZkDataListener;
import org.apache.commons.lang.StringUtils;

public class ClusterNodeAccessStrategy
implements CanalNodeAccessStrategy {
    private String destination;
    private IZkChildListener childListener;
    private IZkDataListener dataListener;
    private ZkClientx zkClient;
    private volatile List<InetSocketAddress> currentAddress = new ArrayList<InetSocketAddress>();
    private volatile InetSocketAddress runningAddress = null;

    public ClusterNodeAccessStrategy(String destination, ZkClientx zkClient) {
        this.destination = destination;
        this.zkClient = zkClient;
        this.childListener = new IZkChildListener(){

            public void handleChildChange(String parentPath, List<String> currentChilds) throws Exception {
                ClusterNodeAccessStrategy.this.initClusters(currentChilds);
            }
        };
        this.dataListener = new IZkDataListener(){

            public void handleDataDeleted(String dataPath) throws Exception {
                ClusterNodeAccessStrategy.this.runningAddress = null;
            }

            public void handleDataChange(String dataPath, Object data) throws Exception {
                ClusterNodeAccessStrategy.this.initRunning(data);
            }
        };
        String clusterPath = ZookeeperPathUtils.getDestinationClusterRoot(destination);
        this.zkClient.subscribeChildChanges(clusterPath, this.childListener);
        this.initClusters(this.zkClient.getChildren(clusterPath));
        String runningPath = ZookeeperPathUtils.getDestinationServerRunning(destination);
        this.zkClient.subscribeDataChanges(runningPath, this.dataListener);
        this.initRunning(this.zkClient.readData(runningPath, true));
    }

    @Override
    public SocketAddress currentNode() {
        return this.nextNode();
    }

    @Override
    public SocketAddress nextNode() {
        if (this.runningAddress != null) {
            return this.runningAddress;
        }
        if (!this.currentAddress.isEmpty()) {
            return this.currentAddress.get(0);
        }
        throw new ServerNotFoundException("no alive canal server for " + this.destination);
    }

    private void initClusters(List<String> currentChilds) {
        if (currentChilds == null || currentChilds.isEmpty()) {
            this.currentAddress = new ArrayList<InetSocketAddress>();
        } else {
            ArrayList<InetSocketAddress> addresses = new ArrayList<InetSocketAddress>();
            for (String address : currentChilds) {
                String[] strs = StringUtils.split((String)address, (String)":");
                if (strs == null || strs.length != 2) continue;
                addresses.add(new InetSocketAddress(strs[0], (int)Integer.valueOf(strs[1])));
            }
            Collections.shuffle(addresses);
            this.currentAddress = addresses;
        }
    }

    private void initRunning(Object data) {
        if (data == null) {
            return;
        }
        ServerRunningData runningData = JsonUtils.unmarshalFromByte((byte[])data, ServerRunningData.class);
        String[] strs = StringUtils.split((String)runningData.getAddress(), (char)':');
        if (strs.length == 2) {
            this.runningAddress = new InetSocketAddress(strs[0], (int)Integer.valueOf(strs[1]));
        }
    }

    public void setZkClient(ZkClientx zkClient) {
        this.zkClient = zkClient;
    }

    public ZkClientx getZkClient() {
        return this.zkClient;
    }
}

