/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.dubbo.registry;

import com.alibaba.cloud.dubbo.registry.DubboCloudRegistry;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.URLBuilder;
import org.apache.dubbo.common.utils.CollectionUtils;
import org.apache.dubbo.registry.NotifyListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractServiceSubscribeHandler {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    protected final URL url;
    protected final NotifyListener listener;
    protected final DubboCloudRegistry registry;
    private final AtomicBoolean inited = new AtomicBoolean(false);

    public AbstractServiceSubscribeHandler(URL url, NotifyListener listener, DubboCloudRegistry registry) {
        this.url = url;
        this.listener = listener;
        this.registry = registry;
    }

    protected void notifyAllSubscribedURLs(URL url, List<URL> subscribedURLs, NotifyListener listener) {
        if (CollectionUtils.isEmpty(subscribedURLs)) {
            listener.notify(Collections.singletonList(this.emptyURL(url)));
        } else {
            listener.notify(subscribedURLs);
        }
    }

    private URL emptyURL(URL url) {
        return URLBuilder.from((URL)url).setProtocol("empty").removeParameter("category").build();
    }

    public void init() {
        if (this.inited.compareAndSet(false, true)) {
            this.doInit();
        }
    }

    protected abstract void doInit();
}

