/*
 * Decompiled with CFR 0.152.
 */
package oracle.sql;

import java.sql.SQLException;
import oracle.jdbc.driver.DatabaseError;
import oracle.sql.CharacterBuffer;
import oracle.sql.CharacterSetWithConverter;
import oracle.sql.CharacterWalker;
import oracle.sql.converter.JdbcCharacterConverters;

class CharacterSetZHTEUC
extends CharacterSetWithConverter {
    static final String CHAR_CONV_SUPERCLASS_NAME = "oracle.sql.converter.CharacterConverterZHTEUC";
    static final int MAX_7BIT = 127;
    static final int CHARLENGTH = 4;
    static Class m_charConvSuperclass;
    char[] m_leadingCodes;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_;
    public static final String BUILD_DATE = "Sat_Aug_14_12:18:34_PDT_2010";
    public static final boolean TRACE = false;

    CharacterSetZHTEUC(int n2, JdbcCharacterConverters jdbcCharacterConverters) {
        super(n2, jdbcCharacterConverters);
        this.m_leadingCodes = jdbcCharacterConverters.getLeadingCodes();
    }

    static CharacterSetZHTEUC getInstance(int n2, JdbcCharacterConverters jdbcCharacterConverters) {
        if (jdbcCharacterConverters.getGroupId() == 5) {
            return new CharacterSetZHTEUC(n2, jdbcCharacterConverters);
        }
        return null;
    }

    @Override
    int decode(CharacterWalker characterWalker) throws SQLException {
        int n2;
        if (characterWalker.next + 1 < characterWalker.bytes.length) {
            n2 = characterWalker.bytes[characterWalker.next] << 8 | characterWalker.bytes[characterWalker.next + 1];
            for (int i2 = 0; i2 < this.m_leadingCodes.length; ++i2) {
                if (n2 != this.m_leadingCodes[i2]) continue;
                if (characterWalker.bytes.length - characterWalker.next < 4) {
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 182, "destination too small");
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                int n3 = 0;
                for (int i3 = 0; i3 < 4; ++i3) {
                    n3 = n3 << 8 | characterWalker.bytes[characterWalker.next++];
                }
                return n3;
            }
        }
        n2 = characterWalker.bytes[characterWalker.next] & 0xFF;
        ++characterWalker.next;
        if (n2 > 127) {
            if (characterWalker.bytes.length > characterWalker.next) {
                n2 = n2 << 8 | characterWalker.bytes[characterWalker.next];
                ++characterWalker.next;
            } else {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 182);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
        }
        return n2;
    }

    @Override
    void encode(CharacterBuffer characterBuffer, int n2) throws SQLException {
        int n3 = n2 >> 16;
        for (int i2 = 0; i2 < this.m_leadingCodes.length; ++i2) {
            if (n3 != this.m_leadingCodes[i2]) continue;
            CharacterSetZHTEUC.need(characterBuffer, 4);
            for (int i3 = 0; i3 < 4; ++i3) {
                characterBuffer.bytes[characterBuffer.next++] = (byte)n2;
                n2 >>= 8;
            }
            return;
        }
        SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 181, "Failed to find valid leading code");
        sQLException.fillInStackTrace();
        throw sQLException;
    }

    static {
        _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    }
}

