/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.zookeeper;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.curator.RetryPolicy;
import org.apache.curator.drivers.TracerDriver;
import org.apache.curator.ensemble.EnsembleProvider;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.CuratorFrameworkFactory;
import org.apache.curator.retry.ExponentialBackoffRetry;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.zookeeper.ConditionalOnZookeeperEnabled;
import org.springframework.cloud.zookeeper.CuratorFrameworkCustomizer;
import org.springframework.cloud.zookeeper.ZookeeperProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration(proxyBeanMethods=false)
@ConditionalOnZookeeperEnabled
@EnableConfigurationProperties
public class ZookeeperAutoConfiguration {
    private static final Log log = LogFactory.getLog(ZookeeperAutoConfiguration.class);

    @Bean
    @ConditionalOnMissingBean
    public ZookeeperProperties zookeeperProperties() {
        return new ZookeeperProperties();
    }

    @Bean(destroyMethod="close")
    @ConditionalOnMissingBean
    public CuratorFramework curatorFramework(RetryPolicy retryPolicy, ZookeeperProperties properties, ObjectProvider<CuratorFrameworkCustomizer> optionalCuratorFrameworkCustomizerProvider, ObjectProvider<EnsembleProvider> optionalEnsembleProvider, ObjectProvider<TracerDriver> optionalTracerDriverProvider) throws Exception {
        CuratorFrameworkFactory.Builder builder = CuratorFrameworkFactory.builder();
        EnsembleProvider ensembleProvider = (EnsembleProvider)optionalEnsembleProvider.getIfAvailable();
        if (ensembleProvider != null) {
            builder.ensembleProvider(ensembleProvider);
        } else {
            builder.connectString(properties.getConnectString());
        }
        builder.sessionTimeoutMs((int)properties.getSessionTimeout().toMillis()).connectionTimeoutMs((int)properties.getConnectionTimeout().toMillis()).retryPolicy(retryPolicy);
        optionalCuratorFrameworkCustomizerProvider.orderedStream().forEach(curatorFrameworkCustomizer -> curatorFrameworkCustomizer.customize(builder));
        CuratorFramework curator = builder.build();
        optionalTracerDriverProvider.ifAvailable(tracerDriver -> {
            if (curator.getZookeeperClient() != null) {
                curator.getZookeeperClient().setTracerDriver(tracerDriver);
            }
        });
        curator.start();
        log.trace((Object)("blocking until connected to zookeeper for " + properties.getBlockUntilConnectedWait() + (Object)((Object)properties.getBlockUntilConnectedUnit())));
        curator.blockUntilConnected(properties.getBlockUntilConnectedWait().intValue(), properties.getBlockUntilConnectedUnit());
        log.trace((Object)"connected to zookeeper");
        return curator;
    }

    @Bean
    @ConditionalOnMissingBean
    public RetryPolicy exponentialBackoffRetry(ZookeeperProperties properties) {
        return new ExponentialBackoffRetry(properties.getBaseSleepTimeMs().intValue(), properties.getMaxRetries().intValue(), properties.getMaxSleepMs().intValue());
    }
}

