/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.binder.rabbit.properties;

import javax.validation.constraints.Min;
import org.springframework.amqp.core.AcknowledgeMode;
import org.springframework.amqp.core.MessageDeliveryMode;
import org.springframework.cloud.stream.binder.rabbit.properties.RabbitCommonProperties;
import org.springframework.util.Assert;

public class RabbitConsumerProperties
extends RabbitCommonProperties {
    private boolean transacted;
    private AcknowledgeMode acknowledgeMode = AcknowledgeMode.AUTO;
    private int maxConcurrency = 1;
    private int prefetch = 1;
    private int batchSize = 1;
    private boolean durableSubscription = true;
    private boolean republishToDlq = true;
    private MessageDeliveryMode republishDeliveyMode = MessageDeliveryMode.PERSISTENT;
    private boolean requeueRejected = false;
    private String[] headerPatterns = new String[]{"*"};
    private long recoveryInterval = 5000L;
    private boolean exclusive;
    private boolean missingQueuesFatal = false;
    private Integer queueDeclarationRetries;
    private Long failedDeclarationRetryInterval;
    private String consumerTagPrefix;
    private int frameMaxHeadroom = 20000;
    private ContainerType containerType = ContainerType.SIMPLE;
    private String anonymousGroupPrefix = "anonymous.";
    private boolean enableBatching;
    private Long receiveTimeout;

    public boolean isTransacted() {
        return this.transacted;
    }

    public void setTransacted(boolean transacted) {
        this.transacted = transacted;
    }

    public AcknowledgeMode getAcknowledgeMode() {
        return this.acknowledgeMode;
    }

    public void setAcknowledgeMode(AcknowledgeMode acknowledgeMode) {
        Assert.notNull((Object)acknowledgeMode, (String)"Acknowledge mode cannot be null");
        this.acknowledgeMode = acknowledgeMode;
    }

    @Min(value=1L, message="Max Concurrency should be greater than zero.")
    public @Min(value=1L, message="Max Concurrency should be greater than zero.") int getMaxConcurrency() {
        return this.maxConcurrency;
    }

    public void setMaxConcurrency(int maxConcurrency) {
        this.maxConcurrency = maxConcurrency;
    }

    @Min(value=1L, message="Prefetch should be greater than zero.")
    public @Min(value=1L, message="Prefetch should be greater than zero.") int getPrefetch() {
        return this.prefetch;
    }

    public void setPrefetch(int prefetch) {
        this.prefetch = prefetch;
    }

    @Deprecated
    public String[] getRequestHeaderPatterns() {
        return this.headerPatterns;
    }

    @Deprecated
    public void setRequestHeaderPatterns(String[] requestHeaderPatterns) {
        this.headerPatterns = requestHeaderPatterns;
    }

    @Deprecated
    @Min(value=1L, message="Tx Size should be greater than zero.")
    public @Min(value=1L, message="Tx Size should be greater than zero.") int getTxSize() {
        return this.getBatchSize();
    }

    public void setTxSize(int txSize) {
        this.setBatchSize(txSize);
    }

    @Min(value=1L, message="Batch Size should be greater than zero.")
    public @Min(value=1L, message="Batch Size should be greater than zero.") int getBatchSize() {
        return this.batchSize;
    }

    public void setBatchSize(int batchSize) {
        this.batchSize = batchSize;
    }

    public boolean isDurableSubscription() {
        return this.durableSubscription;
    }

    public void setDurableSubscription(boolean durableSubscription) {
        this.durableSubscription = durableSubscription;
    }

    public boolean isRepublishToDlq() {
        return this.republishToDlq;
    }

    public void setRepublishToDlq(boolean republishToDlq) {
        this.republishToDlq = republishToDlq;
    }

    public boolean isRequeueRejected() {
        return this.requeueRejected;
    }

    public MessageDeliveryMode getRepublishDeliveyMode() {
        return this.republishDeliveyMode;
    }

    public void setRepublishDeliveyMode(MessageDeliveryMode republishDeliveyMode) {
        this.republishDeliveyMode = republishDeliveyMode;
    }

    public void setRequeueRejected(boolean requeueRejected) {
        this.requeueRejected = requeueRejected;
    }

    public String[] getHeaderPatterns() {
        return this.headerPatterns;
    }

    public void setHeaderPatterns(String[] replyHeaderPatterns) {
        this.headerPatterns = replyHeaderPatterns;
    }

    public long getRecoveryInterval() {
        return this.recoveryInterval;
    }

    public void setRecoveryInterval(long recoveryInterval) {
        this.recoveryInterval = recoveryInterval;
    }

    public boolean isExclusive() {
        return this.exclusive;
    }

    public void setExclusive(boolean exclusive) {
        this.exclusive = exclusive;
    }

    public boolean getMissingQueuesFatal() {
        return this.missingQueuesFatal;
    }

    public void setMissingQueuesFatal(boolean missingQueuesFatal) {
        this.missingQueuesFatal = missingQueuesFatal;
    }

    public Integer getQueueDeclarationRetries() {
        return this.queueDeclarationRetries;
    }

    public void setQueueDeclarationRetries(Integer queueDeclarationRetries) {
        this.queueDeclarationRetries = queueDeclarationRetries;
    }

    public Long getFailedDeclarationRetryInterval() {
        return this.failedDeclarationRetryInterval;
    }

    public void setFailedDeclarationRetryInterval(Long failedDeclarationRetryInterval) {
        this.failedDeclarationRetryInterval = failedDeclarationRetryInterval;
    }

    public String getConsumerTagPrefix() {
        return this.consumerTagPrefix;
    }

    public void setConsumerTagPrefix(String consumerTagPrefix) {
        this.consumerTagPrefix = consumerTagPrefix;
    }

    public int getFrameMaxHeadroom() {
        return this.frameMaxHeadroom;
    }

    public void setFrameMaxHeadroom(int frameMaxHeadroom) {
        this.frameMaxHeadroom = frameMaxHeadroom;
    }

    public ContainerType getContainerType() {
        return this.containerType;
    }

    public void setContainerType(ContainerType containerType) {
        this.containerType = containerType;
    }

    public String getAnonymousGroupPrefix() {
        return this.anonymousGroupPrefix;
    }

    public void setAnonymousGroupPrefix(String anonymousGroupPrefix) {
        this.anonymousGroupPrefix = anonymousGroupPrefix;
    }

    public boolean isEnableBatching() {
        return this.enableBatching;
    }

    public void setEnableBatching(boolean enableBatching) {
        this.enableBatching = enableBatching;
    }

    public Long getReceiveTimeout() {
        return this.receiveTimeout;
    }

    public void setReceiveTimeout(Long receiveTimeout) {
        this.receiveTimeout = receiveTimeout;
    }

    public static enum ContainerType {
        SIMPLE,
        DIRECT,
        STREAM;

    }
}

