/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.zipkin2;

import java.io.IOException;
import java.net.URI;
import java.util.List;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.RequestEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;
import zipkin2.Call;
import zipkin2.Callback;
import zipkin2.CheckResult;
import zipkin2.Span;
import zipkin2.codec.BytesEncoder;
import zipkin2.codec.Encoding;
import zipkin2.codec.SpanBytesEncoder;
import zipkin2.reporter.BytesMessageEncoder;
import zipkin2.reporter.Sender;

public class RestTemplateSender
extends Sender {
    final RestTemplate restTemplate;
    final String url;
    final Encoding encoding;
    final MediaType mediaType;
    final BytesMessageEncoder messageEncoder;
    transient boolean closeCalled;

    public RestTemplateSender(RestTemplate restTemplate, String baseUrl, BytesEncoder<Span> encoder) {
        this.restTemplate = restTemplate;
        this.encoding = encoder.encoding();
        if (encoder.equals((Object)SpanBytesEncoder.JSON_V2)) {
            this.mediaType = MediaType.APPLICATION_JSON;
            this.url = baseUrl + (baseUrl.endsWith("/") ? "" : "/") + "api/v2/spans";
        } else if (this.encoding == Encoding.PROTO3) {
            this.mediaType = MediaType.parseMediaType((String)"application/x-protobuf");
            this.url = baseUrl + (baseUrl.endsWith("/") ? "" : "/") + "api/v2/spans";
        } else if (this.encoding == Encoding.JSON) {
            this.mediaType = MediaType.APPLICATION_JSON;
            this.url = baseUrl + (baseUrl.endsWith("/") ? "" : "/") + "api/v1/spans";
        } else {
            throw new UnsupportedOperationException("Unsupported encoding: " + this.encoding.name());
        }
        this.messageEncoder = BytesMessageEncoder.forEncoding((Encoding)this.encoding);
    }

    public Encoding encoding() {
        return this.encoding;
    }

    public int messageMaxBytes() {
        return 0x500000;
    }

    public int messageSizeInBytes(List<byte[]> spans) {
        return this.encoding().listSizeInBytes(spans);
    }

    public Call<Void> sendSpans(List<byte[]> encodedSpans) {
        if (this.closeCalled) {
            throw new IllegalStateException("close");
        }
        return new HttpPostCall(this.messageEncoder.encode(encodedSpans));
    }

    public CheckResult check() {
        try {
            this.post(new byte[]{91, 93});
            return CheckResult.OK;
        }
        catch (Exception e) {
            return CheckResult.failed((Throwable)e);
        }
    }

    public void close() {
        this.closeCalled = true;
    }

    void post(byte[] json) {
        HttpHeaders httpHeaders = new HttpHeaders();
        httpHeaders.setContentType(this.mediaType);
        RequestEntity requestEntity = new RequestEntity((Object)json, (MultiValueMap)httpHeaders, HttpMethod.POST, URI.create(this.url));
        this.restTemplate.exchange(requestEntity, String.class);
    }

    public String toString() {
        return "RestTemplateSender{" + this.url + "}";
    }

    class HttpPostCall
    extends Call.Base<Void> {
        private final byte[] message;

        HttpPostCall(byte[] message) {
            this.message = message;
        }

        protected Void doExecute() throws IOException {
            RestTemplateSender.this.post(this.message);
            return null;
        }

        protected void doEnqueue(Callback<Void> callback) {
            try {
                RestTemplateSender.this.post(this.message);
                callback.onSuccess(null);
            }
            catch (Error | RuntimeException e) {
                callback.onError(e);
            }
        }

        public Call<Void> clone() {
            return new HttpPostCall(this.message);
        }
    }
}

