/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.log;

import brave.baggage.BaggageField;
import brave.baggage.BaggageFields;
import brave.baggage.CorrelationScopeConfig;
import brave.baggage.CorrelationScopeDecorator;
import brave.context.slf4j.MDCScopeDecorator;
import brave.propagation.CurrentTraceContext;
import brave.propagation.TraceContext;
import java.util.LinkedHashSet;
import java.util.TreeSet;
import org.springframework.cloud.sleuth.autoconfig.SleuthProperties;
import org.springframework.cloud.sleuth.log.SleuthSlf4jProperties;

final class Slf4jScopeDecorator
implements CurrentTraceContext.ScopeDecorator {
    private static final CurrentTraceContext.ScopeDecorator LEGACY_IDS = MDCScopeDecorator.newBuilder().clear().add((CorrelationScopeConfig)CorrelationScopeConfig.SingleCorrelationField.newBuilder((BaggageField)BaggageFields.TRACE_ID).name("X-B3-TraceId").build()).add((CorrelationScopeConfig)CorrelationScopeConfig.SingleCorrelationField.newBuilder((BaggageField)BaggageFields.PARENT_ID).name("X-B3-ParentSpanId").build()).add((CorrelationScopeConfig)CorrelationScopeConfig.SingleCorrelationField.newBuilder((BaggageField)BaggageFields.SPAN_ID).name("X-B3-SpanId").build()).add((CorrelationScopeConfig)CorrelationScopeConfig.SingleCorrelationField.newBuilder((BaggageField)BaggageFields.SAMPLED).name("X-Span-Export").build()).build();
    private final CurrentTraceContext.ScopeDecorator delegate;

    Slf4jScopeDecorator(SleuthProperties sleuthProperties, SleuthSlf4jProperties sleuthSlf4jProperties) {
        CorrelationScopeDecorator.Builder builder = MDCScopeDecorator.newBuilder().clear().add((CorrelationScopeConfig)CorrelationScopeConfig.SingleCorrelationField.create((BaggageField)BaggageFields.TRACE_ID)).add((CorrelationScopeConfig)CorrelationScopeConfig.SingleCorrelationField.create((BaggageField)BaggageFields.PARENT_ID)).add((CorrelationScopeConfig)CorrelationScopeConfig.SingleCorrelationField.create((BaggageField)BaggageFields.SPAN_ID)).add((CorrelationScopeConfig)CorrelationScopeConfig.SingleCorrelationField.newBuilder((BaggageField)BaggageFields.SAMPLED).name("spanExportable").build());
        TreeSet<String> whitelist = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        whitelist.addAll(sleuthSlf4jProperties.getWhitelistedMdcKeys());
        LinkedHashSet<String> retained = new LinkedHashSet<String>();
        retained.addAll(sleuthProperties.getBaggageKeys());
        retained.addAll(sleuthProperties.getLocalKeys());
        retained.addAll(sleuthProperties.getPropagationKeys());
        retained.retainAll(whitelist);
        for (String name : retained) {
            builder.add((CorrelationScopeConfig)CorrelationScopeConfig.SingleCorrelationField.newBuilder((BaggageField)BaggageField.create((String)name)).dirty().build());
        }
        this.delegate = builder.build();
    }

    public CurrentTraceContext.Scope decorateScope(TraceContext context, CurrentTraceContext.Scope scope) {
        return LEGACY_IDS.decorateScope(context, this.delegate.decorateScope(context, scope));
    }
}

