/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.web.client;

import brave.Span;
import brave.http.HttpClientHandler;
import brave.http.HttpClientResponse;
import brave.http.HttpTracing;
import brave.propagation.TraceContext;
import io.netty.bootstrap.Bootstrap;
import java.net.InetSocketAddress;
import java.util.concurrent.CancellationException;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.cloud.sleuth.internal.LazyBean;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.lang.Nullable;
import reactor.core.publisher.Mono;
import reactor.netty.Connection;
import reactor.netty.http.client.HttpClient;
import reactor.netty.http.client.HttpClientRequest;
import reactor.util.context.Context;

class HttpClientBeanPostProcessor
implements BeanPostProcessor {
    final ConfigurableApplicationContext springContext;

    HttpClientBeanPostProcessor(ConfigurableApplicationContext springContext) {
        this.springContext = springContext;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        LazyBean<HttpTracing> httpTracing = LazyBean.create(this.springContext, HttpTracing.class);
        if (bean instanceof HttpClient) {
            TracingDoOnResponse doOnResponse = new TracingDoOnResponse(httpTracing);
            return ((HttpClient)bean).doOnResponseError((BiConsumer)new TracingDoOnErrorResponse(httpTracing)).doOnRedirect((BiConsumer)doOnResponse).doOnResponse((BiConsumer)doOnResponse).doOnRequestError((BiConsumer)new TracingDoOnErrorRequest(httpTracing)).doOnRequest((BiConsumer)new TracingDoOnRequest(httpTracing)).mapConnect((BiFunction)new TracingMapConnect(() -> {
                HttpTracing ref = (HttpTracing)httpTracing.get();
                return ref != null ? ref.tracing().currentTraceContext().get() : null;
            }));
        }
        return bean;
    }

    static final class HttpClientResponseWrapper
    extends HttpClientResponse {
        final reactor.netty.http.client.HttpClientResponse delegate;
        HttpClientRequestWrapper request;

        HttpClientResponseWrapper(reactor.netty.http.client.HttpClientResponse delegate) {
            this.delegate = delegate;
        }

        public Object unwrap() {
            return this.delegate;
        }

        public HttpClientRequestWrapper request() {
            if (this.request == null) {
                if (this.delegate instanceof HttpClientRequest) {
                    this.request = new HttpClientRequestWrapper((HttpClientRequest)this.delegate);
                } else assert (false) : "We expect the response to be the same reference as the request";
            }
            return this.request;
        }

        public int statusCode() {
            return this.delegate.status().code();
        }
    }

    static final class HttpClientRequestWrapper
    extends brave.http.HttpClientRequest {
        final HttpClientRequest delegate;

        HttpClientRequestWrapper(HttpClientRequest delegate) {
            this.delegate = delegate;
        }

        public Object unwrap() {
            return this.delegate;
        }

        public String method() {
            return this.delegate.method().name();
        }

        public String path() {
            return this.delegate.fullPath();
        }

        public String url() {
            return this.delegate.resourceUrl();
        }

        public String header(String name) {
            return this.delegate.requestHeaders().get(name);
        }

        public void header(String name, String value) {
            this.delegate.header((CharSequence)name, (CharSequence)value);
        }
    }

    private static abstract class AbstractTracingDoOnHandler {
        final LazyBean<HttpTracing> httpTracing;
        HttpClientHandler<brave.http.HttpClientRequest, HttpClientResponse> handler;

        AbstractTracingDoOnHandler(LazyBean<HttpTracing> httpTracing) {
            this.httpTracing = httpTracing;
        }

        HttpClientHandler<brave.http.HttpClientRequest, HttpClientResponse> handler() {
            if (this.handler == null) {
                this.handler = HttpClientHandler.create((HttpTracing)this.httpTracing.get());
            }
            return this.handler;
        }

        void handle(Context context, @Nullable reactor.netty.http.client.HttpClientResponse resp, @Nullable Throwable error) {
            PendingSpan pendingSpan = (PendingSpan)context.getOrDefault(PendingSpan.class, null);
            if (pendingSpan == null) {
                return;
            }
            Span span = pendingSpan.getAndSet(null);
            if (span == null) {
                return;
            }
            HttpClientResponseWrapper response = resp != null ? new HttpClientResponseWrapper(resp) : null;
            this.handler().handleReceive((Object)response, error, span);
        }
    }

    private static class TracingDoOnErrorResponse
    extends AbstractTracingDoOnHandler
    implements BiConsumer<reactor.netty.http.client.HttpClientResponse, Throwable> {
        TracingDoOnErrorResponse(LazyBean<HttpTracing> httpTracing) {
            super(httpTracing);
        }

        @Override
        public void accept(reactor.netty.http.client.HttpClientResponse response, Throwable error) {
            this.handle(response.currentContext(), response, error);
        }
    }

    private static class TracingDoOnErrorRequest
    extends AbstractTracingDoOnHandler
    implements BiConsumer<HttpClientRequest, Throwable> {
        TracingDoOnErrorRequest(LazyBean<HttpTracing> httpTracing) {
            super(httpTracing);
        }

        @Override
        public void accept(HttpClientRequest req, Throwable error) {
            this.handle(req.currentContext(), null, error);
        }
    }

    private static class TracingDoOnResponse
    extends AbstractTracingDoOnHandler
    implements BiConsumer<reactor.netty.http.client.HttpClientResponse, Connection> {
        TracingDoOnResponse(LazyBean<HttpTracing> httpTracing) {
            super(httpTracing);
        }

        @Override
        public void accept(reactor.netty.http.client.HttpClientResponse response, Connection connection) {
            this.handle(response.currentContext(), response, null);
        }
    }

    private static class TracingDoOnRequest
    implements BiConsumer<HttpClientRequest, Connection> {
        final LazyBean<HttpTracing> httpTracing;
        HttpClientHandler<brave.http.HttpClientRequest, HttpClientResponse> handler;

        TracingDoOnRequest(LazyBean<HttpTracing> httpTracing) {
            this.httpTracing = httpTracing;
        }

        HttpClientHandler<brave.http.HttpClientRequest, HttpClientResponse> handler() {
            if (this.handler == null) {
                this.handler = HttpClientHandler.create((HttpTracing)this.httpTracing.get());
            }
            return this.handler;
        }

        @Override
        public void accept(HttpClientRequest req, Connection connection) {
            PendingSpan pendingSpan = (PendingSpan)req.currentContext().getOrDefault(PendingSpan.class, null);
            if (pendingSpan == null) {
                return;
            }
            Span span = pendingSpan.getAndSet(null);
            if (span != null) {
                assert (false) : "span exists when it shouldn't!";
                span.abandon();
            }
            TraceContext parent = (TraceContext)req.currentContext().getOrDefault(TraceContext.class, null);
            HttpClientRequestWrapper request = new HttpClientRequestWrapper(req);
            span = this.handler().handleSendWithParent((brave.http.HttpClientRequest)request, parent);
            TracingDoOnRequest.parseConnectionAddress(connection, span);
            pendingSpan.set(span);
        }

        static void parseConnectionAddress(Connection connection, Span span) {
            if (span.isNoop()) {
                return;
            }
            InetSocketAddress socketAddress = connection.address();
            span.remoteIpAndPort(socketAddress.getHostString(), socketAddress.getPort());
        }
    }

    static class TracingMapConnect
    implements BiFunction<Mono<? extends Connection>, Bootstrap, Mono<? extends Connection>> {
        static final Exception CANCELLED_ERROR = new CancellationException("CANCELLED"){

            @Override
            public Throwable fillInStackTrace() {
                return this;
            }
        };
        final Supplier<TraceContext> currentTraceContext;

        TracingMapConnect(Supplier<TraceContext> currentTraceContext) {
            this.currentTraceContext = currentTraceContext;
        }

        @Override
        public Mono<? extends Connection> apply(Mono<? extends Connection> mono, Bootstrap bootstrap) {
            PendingSpan pendingSpan = new PendingSpan();
            return mono.subscriberContext(context -> {
                TraceContext invocationContext = this.currentTraceContext.get();
                if (invocationContext != null) {
                    context = context.put(TraceContext.class, (Object)invocationContext);
                }
                return context.put(PendingSpan.class, (Object)pendingSpan);
            }).doOnCancel(() -> {
                Span span = pendingSpan.getAndSet(null);
                if (span != null) {
                    span.error((Throwable)CANCELLED_ERROR);
                    span.finish();
                }
            });
        }
    }

    static final class PendingSpan
    extends AtomicReference<Span> {
        PendingSpan() {
        }
    }
}

