/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.web;

import brave.http.HttpRequest;
import brave.sampler.SamplerFunction;

final class CompositeHttpSampler
implements SamplerFunction<HttpRequest> {
    final SamplerFunction<HttpRequest> left;
    final SamplerFunction<HttpRequest> right;

    CompositeHttpSampler(SamplerFunction<HttpRequest> left, SamplerFunction<HttpRequest> right) {
        this.left = left;
        this.right = right;
    }

    public Boolean trySample(HttpRequest request) {
        Boolean leftDecision = this.left.trySample((Object)request);
        if (Boolean.FALSE.equals(leftDecision)) {
            return false;
        }
        Boolean rightDecision = this.right.trySample((Object)request);
        if (Boolean.FALSE.equals(rightDecision)) {
            return false;
        }
        if (leftDecision == null) {
            return rightDecision;
        }
        if (rightDecision == null) {
            return leftDecision;
        }
        return rightDecision;
    }
}

