/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.rpc;

import brave.Tracing;
import brave.rpc.RpcRequest;
import brave.rpc.RpcTracing;
import brave.rpc.RpcTracingCustomizer;
import brave.sampler.SamplerFunction;
import java.util.List;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.cloud.sleuth.autoconfig.TraceAutoConfiguration;
import org.springframework.cloud.sleuth.instrument.rpc.RpcClientSampler;
import org.springframework.cloud.sleuth.instrument.rpc.RpcServerSampler;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.lang.Nullable;

@Configuration(proxyBeanMethods=false)
@ConditionalOnProperty(name={"spring.sleuth.rpc.enabled"}, havingValue="true", matchIfMissing=true)
@ConditionalOnBean(value={Tracing.class})
@ConditionalOnClass(value={RpcTracing.class})
@AutoConfigureAfter(value={TraceAutoConfiguration.class})
public class TraceRpcAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    RpcTracing rpcTracing(Tracing tracing, @Nullable @RpcClientSampler SamplerFunction<RpcRequest> clientSampler, @Nullable @RpcServerSampler SamplerFunction<RpcRequest> serverSampler, @Nullable List<RpcTracingCustomizer> rpcTracingCustomizers) {
        RpcTracing.Builder builder = RpcTracing.newBuilder((Tracing)tracing);
        if (clientSampler != null) {
            builder.clientSampler(clientSampler);
        }
        if (serverSampler != null) {
            builder.serverSampler(serverSampler);
        }
        if (rpcTracingCustomizers != null) {
            for (RpcTracingCustomizer customizer : rpcTracingCustomizers) {
                customizer.customize(builder);
            }
        }
        return builder.build();
    }
}

