/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.reactor;

import brave.Span;
import brave.Tracer;
import brave.Tracing;
import brave.propagation.CurrentTraceContext;
import brave.propagation.TraceContext;
import java.util.concurrent.atomic.AtomicBoolean;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import org.springframework.cloud.sleuth.instrument.reactor.SpanSubscription;
import reactor.util.Logger;
import reactor.util.Loggers;
import reactor.util.context.Context;

@Deprecated
final class SpanSubscriber<T>
extends AtomicBoolean
implements SpanSubscription<T> {
    private static final Logger log = Loggers.getLogger(SpanSubscriber.class);
    private final Span span;
    private final TraceContext parent;
    private final Subscriber<? super T> subscriber;
    private final Context context;
    private final Tracer tracer;
    private final CurrentTraceContext currentTraceContext;
    private Subscription s;

    SpanSubscriber(Subscriber<? super T> subscriber, Context ctx, Tracing tracing, String name) {
        this.subscriber = subscriber;
        this.tracer = tracing.tracer();
        this.currentTraceContext = tracing.currentTraceContext();
        TraceContext parent = (TraceContext)ctx.getOrDefault(TraceContext.class, null);
        if (parent == null) {
            parent = this.currentTraceContext.get();
        }
        if (log.isTraceEnabled()) {
            log.trace("Span from context [{}]", new Object[]{parent});
        }
        this.parent = parent;
        if (log.isTraceEnabled()) {
            log.trace("Stored context parent span [{}]", new Object[]{this.parent});
        }
        Span span = this.span = parent != null ? this.tracer.newChild(parent).name(name) : this.tracer.newTrace().name(name);
        if (log.isTraceEnabled()) {
            log.trace("Created span [{}], with name [{}]", new Object[]{this.span, name});
        }
        this.context = ctx.put(TraceContext.class, (Object)this.span.context());
    }

    public void onSubscribe(Subscription subscription) {
        if (log.isTraceEnabled()) {
            log.trace("On subscribe");
        }
        this.s = subscription;
        try (CurrentTraceContext.Scope ws = this.currentTraceContext.maybeScope(this.span.context());){
            if (log.isTraceEnabled()) {
                log.trace("On subscribe - span continued");
            }
            this.subscriber.onSubscribe((Subscription)this);
        }
    }

    public void request(long n) {
        if (log.isTraceEnabled()) {
            log.trace("Request");
        }
        try (CurrentTraceContext.Scope ws = this.currentTraceContext.maybeScope(this.span.context());){
            if (log.isTraceEnabled()) {
                log.trace("Request - continued");
            }
            this.s.request(n);
            if (log.isTraceEnabled()) {
                log.trace("Request after cleaning. Current span [{}]", new Object[]{this.span.context()});
            }
        }
    }

    public void cancel() {
        try {
            if (log.isTraceEnabled()) {
                log.trace("Cancel");
            }
            this.s.cancel();
        }
        finally {
            this.cleanup();
        }
    }

    public void onNext(T o) {
        this.subscriber.onNext(o);
    }

    public void onError(Throwable throwable) {
        try {
            this.subscriber.onError(throwable);
        }
        finally {
            this.cleanup();
        }
    }

    public void onComplete() {
        try {
            this.subscriber.onComplete();
        }
        finally {
            this.cleanup();
        }
    }

    void cleanup() {
        if (this.compareAndSet(false, true)) {
            if (log.isTraceEnabled()) {
                log.trace("Cleaning up");
            }
            this.span.finish();
            if (log.isTraceEnabled()) {
                log.trace("Span closed");
            }
            if (this.parent != null) {
                this.tracer.toSpan(this.parent).finish();
                if (log.isTraceEnabled()) {
                    log.trace("Closed parent span");
                }
            }
        }
    }

    public Context currentContext() {
        return this.context;
    }
}

