/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.messaging;

import brave.spring.rabbit.SpringRabbitTracing;
import org.springframework.amqp.rabbit.config.SimpleRabbitListenerContainerFactory;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.config.BeanPostProcessor;

class SleuthRabbitBeanPostProcessor
implements BeanPostProcessor {
    private final BeanFactory beanFactory;
    private SpringRabbitTracing tracing;

    SleuthRabbitBeanPostProcessor(BeanFactory beanFactory) {
        this.beanFactory = beanFactory;
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        if (bean instanceof RabbitTemplate) {
            return this.rabbitTracing().decorateRabbitTemplate((RabbitTemplate)bean);
        }
        if (bean instanceof SimpleRabbitListenerContainerFactory) {
            return this.rabbitTracing().decorateSimpleRabbitListenerContainerFactory((SimpleRabbitListenerContainerFactory)bean);
        }
        return bean;
    }

    SpringRabbitTracing rabbitTracing() {
        if (this.tracing == null) {
            this.tracing = (SpringRabbitTracing)this.beanFactory.getBean(SpringRabbitTracing.class);
        }
        return this.tracing;
    }
}

