/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.autoconfig;

import brave.Tags;
import brave.baggage.BaggageField;
import brave.baggage.BaggagePropagation;
import brave.baggage.BaggagePropagationConfig;
import brave.baggage.BaggagePropagationCustomizer;
import brave.baggage.CorrelationScopeConfig;
import brave.baggage.CorrelationScopeCustomizer;
import brave.baggage.CorrelationScopeDecorator;
import brave.context.slf4j.MDCScopeDecorator;
import brave.handler.MutableSpan;
import brave.handler.SpanHandler;
import brave.propagation.B3Propagation;
import brave.propagation.CurrentTraceContext;
import brave.propagation.ExtraFieldCustomizer;
import brave.propagation.ExtraFieldPropagation;
import brave.propagation.Propagation;
import brave.propagation.TraceContext;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.slf4j.MDC;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.AnyNestedCondition;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.sleuth.autoconfig.SleuthBaggageProperties;
import org.springframework.cloud.sleuth.autoconfig.SleuthProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ConfigurationCondition;
import org.springframework.lang.Nullable;

@Configuration(proxyBeanMethods=false)
@EnableConfigurationProperties(value={SleuthProperties.class, SleuthBaggageProperties.class})
class TraceBaggageConfiguration {
    static final Log logger = LogFactory.getLog(TraceBaggageConfiguration.class);
    static final String LOCAL_KEYS = "spring.sleuth.local-keys";
    static final String BAGGAGE_KEYS = "spring.sleuth.baggage-keys";
    static final String PROPAGATION_KEYS = "spring.sleuth.propagation-keys";
    static final String WHITELISTED_KEYS = "spring.sleuth.propagation.tag.whitelisted-keys";
    static final String WHITELISTED_MDC_KEYS = "spring.sleuth.log.slf4j.whitelisted-mdc-keys";
    static final Propagation.Factory B3_FACTORY = B3Propagation.newFactoryBuilder().injectFormat(B3Propagation.Format.SINGLE_NO_PARENT).build();

    TraceBaggageConfiguration() {
    }

    @Bean(value={"spring.sleuth.baggage-keys"})
    @ConfigurationProperties(value="spring.sleuth.baggage-keys")
    List<String> baggageKeys() {
        return new ArrayList<String>();
    }

    @Bean(value={"spring.sleuth.local-keys"})
    @ConfigurationProperties(value="spring.sleuth.local-keys")
    List<String> localKeys() {
        return new ArrayList<String>();
    }

    @Bean(value={"spring.sleuth.propagation-keys"})
    @ConfigurationProperties(value="spring.sleuth.propagation-keys")
    List<String> propagationKeys() {
        return new ArrayList<String>();
    }

    @Bean(value={"spring.sleuth.log.slf4j.whitelisted-mdc-keys"})
    @ConfigurationProperties(value="spring.sleuth.log.slf4j.whitelisted-mdc-keys")
    List<String> whiteListedMDCKeys() {
        return new ArrayList<String>();
    }

    @Bean
    @ConditionalOnMissingBean
    BaggagePropagation.FactoryBuilder baggagePropagationFactoryBuilder() {
        return BaggagePropagation.newFactoryBuilder((Propagation.Factory)B3_FACTORY);
    }

    @Bean
    @ConditionalOnMissingBean
    Propagation.Factory sleuthPropagation(@Nullable ExtraFieldPropagation.FactoryBuilder extraFieldPropagationFactoryBuilder, @Nullable List<ExtraFieldCustomizer> extraFieldCustomizers, BaggagePropagation.FactoryBuilder factoryBuilder, @Qualifier(value="spring.sleuth.baggage-keys") List<String> baggageKeys, @Qualifier(value="spring.sleuth.local-keys") List<String> localKeys, @Qualifier(value="spring.sleuth.propagation-keys") List<String> propagationKeys, SleuthBaggageProperties sleuthBaggageProperties, @Nullable List<BaggagePropagationCustomizer> baggagePropagationCustomizers) {
        boolean useDeprecated = false;
        if (extraFieldPropagationFactoryBuilder != null) {
            logger.warn((Object)"ExtraFieldPropagation.FactoryBuilder is deprecated. Please switch to BaggagePropagation.FactoryBuilder");
            useDeprecated = true;
        }
        if (extraFieldCustomizers != null) {
            logger.warn((Object)"ExtraFieldCustomizer is deprecated. Please switch to BaggagePropagationCustomizer");
            useDeprecated = true;
        }
        if (useDeprecated) {
            return this.sleuthPropagation(extraFieldPropagationFactoryBuilder, localKeys, propagationKeys, baggageKeys, extraFieldCustomizers);
        }
        Set<String> localFields = TraceBaggageConfiguration.redirectOldPropertyToNew(LOCAL_KEYS, localKeys, "spring.sleuth.baggage.local-fields", sleuthBaggageProperties.getLocalFields());
        for (String fieldName : localFields) {
            factoryBuilder.add((BaggagePropagationConfig)BaggagePropagationConfig.SingleBaggageField.local((BaggageField)BaggageField.create((String)fieldName)));
        }
        Set<String> remoteFields = TraceBaggageConfiguration.redirectOldPropertyToNew(PROPAGATION_KEYS, propagationKeys, "spring.sleuth.baggage.remote-fields", sleuthBaggageProperties.getRemoteFields());
        for (String fieldName : remoteFields) {
            factoryBuilder.add((BaggagePropagationConfig)BaggagePropagationConfig.SingleBaggageField.remote((BaggageField)BaggageField.create((String)fieldName)));
        }
        if (!baggageKeys.isEmpty()) {
            logger.warn((Object)("'spring.sleuth.baggage-keys' will be removed in a future release.\nTo change header names define a @Bean of type " + BaggagePropagationConfig.SingleBaggageField.class.getName()));
            for (String key : baggageKeys) {
                factoryBuilder.add((BaggagePropagationConfig)BaggagePropagationConfig.SingleBaggageField.newBuilder((BaggageField)BaggageField.create((String)key)).addKeyName("baggage-" + key).addKeyName("baggage_" + key).build());
            }
        }
        if (baggagePropagationCustomizers != null) {
            for (BaggagePropagationCustomizer customizer : baggagePropagationCustomizers) {
                customizer.customize(factoryBuilder);
            }
        }
        return factoryBuilder.build();
    }

    Propagation.Factory sleuthPropagation(ExtraFieldPropagation.FactoryBuilder extraFieldPropagationFactoryBuilder, List<String> baggageKeys, List<String> localKeys, List<String> propagationKeys, @Nullable List<ExtraFieldCustomizer> extraFieldCustomizers) {
        if (extraFieldCustomizers == null) {
            extraFieldCustomizers = Collections.emptyList();
        }
        ExtraFieldPropagation.FactoryBuilder factoryBuilder = extraFieldPropagationFactoryBuilder != null ? extraFieldPropagationFactoryBuilder : ExtraFieldPropagation.newFactoryBuilder((Propagation.Factory)B3Propagation.FACTORY);
        if (!baggageKeys.isEmpty()) {
            factoryBuilder.addPrefixedFields("baggage-", baggageKeys).addPrefixedFields("baggage_", baggageKeys);
        }
        for (String string : propagationKeys) {
            factoryBuilder.addField(string);
        }
        for (String string : localKeys) {
            factoryBuilder.addRedactedField(string);
        }
        for (ExtraFieldCustomizer extraFieldCustomizer : extraFieldCustomizers) {
            extraFieldCustomizer.customize(factoryBuilder);
        }
        return factoryBuilder.build();
    }

    static Set<String> redirectOldPropertyToNew(String oldProperty, List<String> oldValue, String newProperty, List<String> newValue) {
        TreeSet<String> result = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        result.addAll(newValue);
        if (!oldValue.isEmpty()) {
            logger.warn((Object)("'" + oldProperty + "' has been renamed to '" + newProperty + "' and will be removed in a future release."));
            result.addAll(oldValue);
        }
        return result;
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnClass(value={MDC.class})
    CorrelationScopeDecorator.Builder correlationScopeDecoratorBuilder() {
        return MDCScopeDecorator.newBuilder();
    }

    @Bean
    @ConditionalOnMissingBean(value={CorrelationScopeDecorator.class})
    @ConditionalOnBean(value={CorrelationScopeDecorator.Builder.class})
    @ConditionalOnProperty(value={"spring.sleuth.baggage.correlation-enabled"}, matchIfMissing=true)
    CurrentTraceContext.ScopeDecorator correlationScopeDecorator(@Qualifier(value="spring.sleuth.log.slf4j.whitelisted-mdc-keys") List<String> whiteListedMDCKeys, SleuthBaggageProperties sleuthBaggageProperties, @Nullable List<CorrelationScopeCustomizer> correlationScopeCustomizers) {
        Set<String> correlationFields = TraceBaggageConfiguration.redirectOldPropertyToNew(WHITELISTED_MDC_KEYS, whiteListedMDCKeys, "spring.sleuth.baggage.correlation-fields", sleuthBaggageProperties.getCorrelationFields());
        CorrelationScopeDecorator.Builder builder = MDCScopeDecorator.newBuilder();
        for (String field : correlationFields) {
            builder.add((CorrelationScopeConfig)CorrelationScopeConfig.SingleCorrelationField.newBuilder((BaggageField)BaggageField.create((String)field)).build());
        }
        if (correlationScopeCustomizers != null) {
            for (CorrelationScopeCustomizer customizer : correlationScopeCustomizers) {
                customizer.customize(builder);
            }
        }
        return builder.build();
    }

    static final class BaggageTagSpanHandler
    extends SpanHandler {
        final BaggageField[] fieldsToTag;

        BaggageTagSpanHandler(BaggageField[] fieldsToTag) {
            this.fieldsToTag = fieldsToTag;
        }

        public boolean end(TraceContext context, MutableSpan span, SpanHandler.Cause cause) {
            for (BaggageField field : this.fieldsToTag) {
                Tags.BAGGAGE_FIELD.tag((Object)field, context, span);
            }
            return true;
        }
    }

    static class BaggageTagSpanHandlerCondition
    extends AnyNestedCondition {
        BaggageTagSpanHandlerCondition() {
            super(ConfigurationCondition.ConfigurationPhase.PARSE_CONFIGURATION);
        }

        @ConditionalOnProperty(value={"spring.sleuth.propagation.tag.whitelisted-keys[0]"})
        static class WhitelistedKeysYamlListProperty {
            WhitelistedKeysYamlListProperty() {
            }
        }

        @ConditionalOnProperty(value={"spring.sleuth.propagation.tag.whitelisted-keys"})
        static class WhitelistedKeysProperty {
            WhitelistedKeysProperty() {
            }
        }

        @ConditionalOnProperty(value={"spring.sleuth.baggage.tag-fields[0]"})
        static class TagFieldsYamlListProperty {
            TagFieldsYamlListProperty() {
            }
        }

        @ConditionalOnProperty(value={"spring.sleuth.baggage.tag-fields"})
        static class TagFieldsProperty {
            TagFieldsProperty() {
            }
        }
    }

    @Configuration
    @Conditional(value={BaggageTagSpanHandlerCondition.class})
    @EnableConfigurationProperties(value={SleuthBaggageProperties.class})
    static class BaggageTagSpanHandlerConfiguration {
        BaggageTagSpanHandlerConfiguration() {
        }

        @Bean(value={"spring.sleuth.propagation.tag.whitelisted-keys"})
        @ConfigurationProperties(value="spring.sleuth.propagation.tag.whitelisted-keys")
        List<String> whiteListedKeys() {
            return new ArrayList<String>();
        }

        @Bean
        SpanHandler baggageTagSpanHandler(@Qualifier(value="spring.sleuth.propagation.tag.whitelisted-keys") List<String> whiteListedKeys, SleuthBaggageProperties sleuthBaggageProperties) {
            Set<String> tagFields = TraceBaggageConfiguration.redirectOldPropertyToNew(TraceBaggageConfiguration.WHITELISTED_KEYS, whiteListedKeys, "spring.sleuth.baggage.tag-fields", sleuthBaggageProperties.getTagFields());
            if (tagFields.isEmpty()) {
                return SpanHandler.NOOP;
            }
            return new BaggageTagSpanHandler((BaggageField[])tagFields.stream().map(BaggageField::create).toArray(BaggageField[]::new));
        }
    }
}

