/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.autoconfig;

import brave.baggage.BaggagePropagationConfig;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.boot.context.properties.ConfigurationProperties;

@ConfigurationProperties(value="spring.sleuth")
public class SleuthProperties {
    private static final Log log = LogFactory.getLog(SleuthProperties.class);
    private boolean enabled = true;
    private boolean traceId128 = false;
    private boolean supportsJoin = true;
    @Deprecated
    private List<String> baggageKeys = new ArrayList<String>();
    @Deprecated
    private List<String> propagationKeys = new ArrayList<String>();
    @Deprecated
    private List<String> localKeys = new ArrayList<String>();

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public boolean isTraceId128() {
        return this.traceId128;
    }

    public void setTraceId128(boolean traceId128) {
        this.traceId128 = traceId128;
    }

    public boolean isSupportsJoin() {
        return this.supportsJoin;
    }

    public void setSupportsJoin(boolean supportsJoin) {
        this.supportsJoin = supportsJoin;
    }

    public List<String> getBaggageKeys() {
        return this.baggageKeys;
    }

    public void setBaggageKeys(List<String> baggageKeys) {
        log.warn((Object)("[spring.sleuth.baggage-keys] will be removed in a future release.To change header names define a @Bean of type " + BaggagePropagationConfig.SingleBaggageField.class.getName() + ". The preferable approach is to migrate to using [spring.sleuth.baggage.remote-keys]. The [spring.sleuth.baggage-keys] would prefix the headers with [baggage_] and [baggage-] so unless all of your applications migrate, to remain backward compatible you would have to add e.g. for [spring.sleuth.baggage-keys=foo] an entry [spring.sleuth.baggage.remote-keys=foo,baggage-foo,baggage_foo] and eventually migrate to [spring.sleuth.baggage.remote-keys=foo]"));
        this.baggageKeys = baggageKeys;
    }

    public List<String> getPropagationKeys() {
        return this.propagationKeys;
    }

    public void setPropagationKeys(List<String> propagationKeys) {
        this.warning("spring.sleuth.propagation-keys", "spring.sleuth.baggage.remote-fields");
        this.propagationKeys = propagationKeys;
    }

    public List<String> getLocalKeys() {
        return this.localKeys;
    }

    public void setLocalKeys(List<String> localKeys) {
        this.warning("spring.sleuth.local-keys", "spring.sleuth.baggage.local-fields");
        this.localKeys = localKeys;
    }

    private void warning(String currentKey, String newKey) {
        log.warn((Object)("The [" + currentKey + "] property is deprecated and is removed in the next major release version of Sleuth. Please use [" + newKey + "]"));
    }
}

