/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.openfeign;

import org.springframework.cloud.openfeign.FeignClientFactoryBean;
import org.springframework.cloud.openfeign.FeignClientsRegistrar;
import org.springframework.context.ApplicationContext;

public class FeignClientBuilder {
    private final ApplicationContext applicationContext;

    public FeignClientBuilder(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    public <T> Builder<T> forType(Class<T> type, String name) {
        return new Builder(this.applicationContext, type, name);
    }

    public <T> Builder<T> forType(Class<T> type, FeignClientFactoryBean clientFactoryBean, String name) {
        return new Builder(this.applicationContext, clientFactoryBean, type, name);
    }

    public static final class Builder<T> {
        private FeignClientFactoryBean feignClientFactoryBean;

        private Builder(ApplicationContext applicationContext, Class<T> type, String name) {
            this(applicationContext, new FeignClientFactoryBean(), type, name);
        }

        private Builder(ApplicationContext applicationContext, FeignClientFactoryBean clientFactoryBean, Class<T> type, String name) {
            this.feignClientFactoryBean = clientFactoryBean;
            this.feignClientFactoryBean.setApplicationContext(applicationContext);
            this.feignClientFactoryBean.setType(type);
            this.feignClientFactoryBean.setName(FeignClientsRegistrar.getName(name));
            this.feignClientFactoryBean.setContextId(FeignClientsRegistrar.getName(name));
            this.feignClientFactoryBean.setInheritParentContext(true);
            this.url("").path("").decode404(false);
        }

        public Builder<T> url(String url) {
            this.feignClientFactoryBean.setUrl(FeignClientsRegistrar.getUrl(url));
            return this;
        }

        public Builder<T> contextId(String contextId) {
            this.feignClientFactoryBean.setContextId(contextId);
            return this;
        }

        public Builder<T> path(String path) {
            this.feignClientFactoryBean.setPath(FeignClientsRegistrar.getPath(path));
            return this;
        }

        public Builder<T> decode404(boolean decode404) {
            this.feignClientFactoryBean.setDecode404(decode404);
            return this;
        }

        public Builder<T> inheritParentContext(boolean inheritParentContext) {
            this.feignClientFactoryBean.setInheritParentContext(inheritParentContext);
            return this;
        }

        public Builder<T> fallback(Class<? extends T> fallback) {
            FeignClientsRegistrar.validateFallback(fallback);
            this.feignClientFactoryBean.setFallback(fallback);
            return this;
        }

        public T build() {
            return this.feignClientFactoryBean.getTarget();
        }
    }
}

