/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.openfeign.support;

import feign.querymap.BeanQueryMapEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;

public class PageableSpringQueryMapEncoder
extends BeanQueryMapEncoder {
    public Map<String, Object> encode(Object object) {
        if (this.supports(object)) {
            HashMap<String, Object> queryMap = new HashMap<String, Object>();
            if (object instanceof Pageable) {
                Pageable pageable = (Pageable)object;
                if (pageable.isPaged()) {
                    queryMap.put("page", pageable.getPageNumber());
                    queryMap.put("size", pageable.getPageSize());
                }
                if (pageable.getSort() != null) {
                    this.applySort(queryMap, pageable.getSort());
                }
            } else if (object instanceof Sort) {
                Sort sort = (Sort)object;
                this.applySort(queryMap, sort);
            }
            return queryMap;
        }
        return super.encode(object);
    }

    private void applySort(Map<String, Object> queryMap, Sort sort) {
        ArrayList<String> sortQueries = new ArrayList<String>();
        for (Sort.Order order : sort) {
            sortQueries.add(order.getProperty() + "%2C" + order.getDirection());
        }
        if (!sortQueries.isEmpty()) {
            queryMap.put("sort", sortQueries);
        }
    }

    protected boolean supports(Object object) {
        return object instanceof Pageable || object instanceof Sort;
    }
}

