/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.kubernetes.profile;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.boot.context.event.ApplicationEnvironmentPreparedEvent;
import org.springframework.cloud.kubernetes.PodUtils;
import org.springframework.context.ApplicationListener;
import org.springframework.core.Ordered;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.Environment;

public class KubernetesProfileApplicationListener
implements ApplicationListener<ApplicationEnvironmentPreparedEvent>,
Ordered {
    private static final Log LOG = LogFactory.getLog(KubernetesProfileApplicationListener.class);
    private static final String KUBERNETES_PROFILE = "kubernetes";
    private static final int OFFSET = 1;
    private static final int ORDER = -2147483647;
    private final PodUtils utils;

    public KubernetesProfileApplicationListener(PodUtils utils) {
        this.utils = utils;
    }

    public void onApplicationEvent(ApplicationEnvironmentPreparedEvent event) {
        ConfigurableEnvironment environment = event.getEnvironment();
        this.addKubernetesProfile(environment);
    }

    void addKubernetesProfile(ConfigurableEnvironment environment) {
        if (this.utils.isInsideKubernetes().booleanValue()) {
            if (this.hasKubernetesProfile((Environment)environment)) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"'kubernetes' already in list of active profiles");
                }
            } else {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"Adding 'kubernetes' to list of active profiles");
                }
                environment.addActiveProfile(KUBERNETES_PROFILE);
            }
        } else if (LOG.isDebugEnabled()) {
            LOG.warn((Object)"Not running inside kubernetes. Skipping 'kubernetes' profile activation.");
        }
    }

    private boolean hasKubernetesProfile(Environment environment) {
        for (String activeProfile : environment.getActiveProfiles()) {
            if (!KUBERNETES_PROFILE.equalsIgnoreCase(activeProfile)) continue;
            return true;
        }
        return false;
    }

    public int getOrder() {
        return -2147483647;
    }
}

