/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.filter.factory.rewrite;

import java.util.Map;
import org.reactivestreams.Publisher;
import org.springframework.cloud.gateway.filter.GatewayFilter;
import org.springframework.cloud.gateway.filter.GatewayFilterChain;
import org.springframework.cloud.gateway.filter.factory.AbstractGatewayFilterFactory;
import org.springframework.cloud.gateway.filter.factory.GatewayFilterFactory;
import org.springframework.cloud.gateway.filter.factory.rewrite.CachedBodyOutputMessage;
import org.springframework.cloud.gateway.filter.factory.rewrite.RewriteFunction;
import org.springframework.cloud.gateway.support.BodyInserterContext;
import org.springframework.cloud.gateway.support.GatewayToStringStyler;
import org.springframework.cloud.gateway.support.ShortcutConfigurable;
import org.springframework.core.Ordered;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.ReactiveHttpOutputMessage;
import org.springframework.http.ResponseCookie;
import org.springframework.http.client.reactive.ClientHttpResponse;
import org.springframework.http.codec.ServerCodecConfigurer;
import org.springframework.http.server.reactive.ServerHttpResponse;
import org.springframework.http.server.reactive.ServerHttpResponseDecorator;
import org.springframework.util.MultiValueMap;
import org.springframework.web.reactive.function.BodyInserter;
import org.springframework.web.reactive.function.BodyInserters;
import org.springframework.web.reactive.function.client.ClientResponse;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class ModifyResponseBodyGatewayFilterFactory
extends AbstractGatewayFilterFactory<Config> {
    public ModifyResponseBodyGatewayFilterFactory() {
        super(Config.class);
    }

    @Deprecated
    public ModifyResponseBodyGatewayFilterFactory(ServerCodecConfigurer codecConfigurer) {
        this();
    }

    @Override
    public GatewayFilter apply(Config config) {
        ModifyResponseGatewayFilter gatewayFilter = new ModifyResponseGatewayFilter(config);
        gatewayFilter.setFactory(this);
        return gatewayFilter;
    }

    @Deprecated
    public class ResponseAdapter
    implements ClientHttpResponse {
        private final Flux<DataBuffer> flux;
        private final HttpHeaders headers;

        public ResponseAdapter(Publisher<? extends DataBuffer> body, HttpHeaders headers) {
            this.headers = headers;
            this.flux = body instanceof Flux ? (Flux)body : ((Mono)body).flux();
        }

        public Flux<DataBuffer> getBody() {
            return this.flux;
        }

        public HttpHeaders getHeaders() {
            return this.headers;
        }

        public HttpStatus getStatusCode() {
            return null;
        }

        public int getRawStatusCode() {
            return 0;
        }

        public MultiValueMap<String, ResponseCookie> getCookies() {
            return null;
        }
    }

    public class ModifyResponseGatewayFilter
    implements GatewayFilter,
    Ordered {
        private final Config config;
        private GatewayFilterFactory<Config> gatewayFilterFactory;

        public ModifyResponseGatewayFilter(Config config) {
            this.config = config;
        }

        @Override
        public Mono<Void> filter(ServerWebExchange exchange, GatewayFilterChain chain) {
            return chain.filter(exchange.mutate().response(this.decorate(exchange)).build());
        }

        ServerHttpResponse decorate(final ServerWebExchange exchange) {
            return new ServerHttpResponseDecorator(exchange.getResponse()){

                public Mono<Void> writeWith(Publisher<? extends DataBuffer> body) {
                    Class inClass = ModifyResponseGatewayFilter.this.config.getInClass();
                    Class outClass = ModifyResponseGatewayFilter.this.config.getOutClass();
                    String originalResponseContentType = (String)exchange.getAttribute("original_response_content_type");
                    HttpHeaders httpHeaders = new HttpHeaders();
                    httpHeaders.add("Content-Type", originalResponseContentType);
                    ClientResponse clientResponse = ClientResponse.create((HttpStatus)exchange.getResponse().getStatusCode()).headers(headers -> headers.putAll((Map)httpHeaders)).body(Flux.from(body)).build();
                    Mono modifiedBody = clientResponse.bodyToMono(inClass).flatMap(originalBody -> ModifyResponseGatewayFilter.this.config.rewriteFunction.apply(exchange, originalBody));
                    BodyInserter bodyInserter = BodyInserters.fromPublisher((Publisher)modifiedBody, (Class)outClass);
                    CachedBodyOutputMessage outputMessage = new CachedBodyOutputMessage(exchange, exchange.getResponse().getHeaders());
                    return bodyInserter.insert((ReactiveHttpOutputMessage)outputMessage, (BodyInserter.Context)new BodyInserterContext()).then(Mono.defer(() -> {
                        Flux messageBody = outputMessage.getBody();
                        HttpHeaders headers = this.getDelegate().getHeaders();
                        if (!headers.containsKey((Object)"Transfer-Encoding")) {
                            messageBody = messageBody.doOnNext(data -> headers.setContentLength((long)data.readableByteCount()));
                        }
                        return this.getDelegate().writeWith(messageBody);
                    }));
                }

                public Mono<Void> writeAndFlushWith(Publisher<? extends Publisher<? extends DataBuffer>> body) {
                    return this.writeWith((Publisher<? extends DataBuffer>)Flux.from(body).flatMapSequential(p -> p));
                }
            };
        }

        public int getOrder() {
            return -2;
        }

        public String toString() {
            ShortcutConfigurable obj = this.gatewayFilterFactory != null ? this.gatewayFilterFactory : this;
            return GatewayToStringStyler.filterToStringCreator(obj).append("New content type", (Object)this.config.getNewContentType()).append("In class", (Object)this.config.getInClass()).append("Out class", (Object)this.config.getOutClass()).toString();
        }

        public void setFactory(GatewayFilterFactory<Config> gatewayFilterFactory) {
            this.gatewayFilterFactory = gatewayFilterFactory;
        }
    }

    public static class Config {
        private Class inClass;
        private Class outClass;
        private Map<String, Object> inHints;
        private Map<String, Object> outHints;
        private String newContentType;
        private RewriteFunction rewriteFunction;

        public Class getInClass() {
            return this.inClass;
        }

        public Config setInClass(Class inClass) {
            this.inClass = inClass;
            return this;
        }

        public Class getOutClass() {
            return this.outClass;
        }

        public Config setOutClass(Class outClass) {
            this.outClass = outClass;
            return this;
        }

        public Map<String, Object> getInHints() {
            return this.inHints;
        }

        public Config setInHints(Map<String, Object> inHints) {
            this.inHints = inHints;
            return this;
        }

        public Map<String, Object> getOutHints() {
            return this.outHints;
        }

        public Config setOutHints(Map<String, Object> outHints) {
            this.outHints = outHints;
            return this;
        }

        public String getNewContentType() {
            return this.newContentType;
        }

        public Config setNewContentType(String newContentType) {
            this.newContentType = newContentType;
            return this;
        }

        public RewriteFunction getRewriteFunction() {
            return this.rewriteFunction;
        }

        public Config setRewriteFunction(RewriteFunction rewriteFunction) {
            this.rewriteFunction = rewriteFunction;
            return this;
        }

        public <T, R> Config setRewriteFunction(Class<T> inClass, Class<R> outClass, RewriteFunction<T, R> rewriteFunction) {
            this.setInClass(inClass);
            this.setOutClass(outClass);
            this.setRewriteFunction(rewriteFunction);
            return this;
        }
    }
}

