/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.filter.factory;

import java.util.Arrays;
import java.util.List;
import org.springframework.cloud.gateway.filter.GatewayFilter;
import org.springframework.cloud.gateway.filter.GatewayFilterChain;
import org.springframework.cloud.gateway.filter.factory.AbstractGatewayFilterFactory;
import org.springframework.cloud.gateway.support.GatewayToStringStyler;
import org.springframework.cloud.gateway.support.HttpStatusHolder;
import org.springframework.cloud.gateway.support.ServerWebExchangeUtils;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

public class SetStatusGatewayFilterFactory
extends AbstractGatewayFilterFactory<Config> {
    public static final String STATUS_KEY = "status";

    public SetStatusGatewayFilterFactory() {
        super(Config.class);
    }

    @Override
    public List<String> shortcutFieldOrder() {
        return Arrays.asList(STATUS_KEY);
    }

    @Override
    public GatewayFilter apply(final Config config) {
        final HttpStatusHolder statusHolder = HttpStatusHolder.parse(config.status);
        return new GatewayFilter(){

            @Override
            public Mono<Void> filter(ServerWebExchange exchange, GatewayFilterChain chain) {
                return chain.filter(exchange).then(Mono.fromRunnable(() -> ServerWebExchangeUtils.setResponseStatus(exchange, statusHolder)));
            }

            public String toString() {
                return GatewayToStringStyler.filterToStringCreator(SetStatusGatewayFilterFactory.this).append(SetStatusGatewayFilterFactory.STATUS_KEY, (Object)config.getStatus()).toString();
            }
        };
    }

    public static class Config {
        private String status;

        public String getStatus() {
            return this.status;
        }

        public void setStatus(String status) {
            this.status = status;
        }
    }
}

