/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.handler;

import org.reactivestreams.Publisher;
import org.springframework.cloud.gateway.handler.FilteringWebHandler;
import org.springframework.cloud.gateway.route.Route;
import org.springframework.cloud.gateway.route.RouteLocator;
import org.springframework.cloud.gateway.support.ServerWebExchangeUtils;
import org.springframework.web.cors.CorsConfiguration;
import org.springframework.web.reactive.handler.AbstractHandlerMapping;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

public class RoutePredicateHandlerMapping
extends AbstractHandlerMapping {
    private final FilteringWebHandler webHandler;
    private final RouteLocator routeLocator;

    public RoutePredicateHandlerMapping(FilteringWebHandler webHandler, RouteLocator routeLocator) {
        this.webHandler = webHandler;
        this.routeLocator = routeLocator;
        this.setOrder(1);
    }

    protected Mono<?> getHandlerInternal(ServerWebExchange exchange) {
        exchange.getAttributes().put(ServerWebExchangeUtils.GATEWAY_HANDLER_MAPPER_ATTR, ((Object)((Object)this)).getClass().getSimpleName());
        return this.lookupRoute(exchange).flatMap(r -> {
            exchange.getAttributes().remove(ServerWebExchangeUtils.GATEWAY_PREDICATE_ROUTE_ATTR);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Mapping [" + this.getExchangeDesc(exchange) + "] to " + r));
            }
            exchange.getAttributes().put(ServerWebExchangeUtils.GATEWAY_ROUTE_ATTR, r);
            return Mono.just((Object)this.webHandler);
        }).switchIfEmpty(Mono.empty().then(Mono.fromRunnable(() -> {
            exchange.getAttributes().remove(ServerWebExchangeUtils.GATEWAY_PREDICATE_ROUTE_ATTR);
            if (this.logger.isTraceEnabled()) {
                this.logger.trace((Object)("No RouteDefinition found for [" + this.getExchangeDesc(exchange) + "]"));
            }
        })));
    }

    protected CorsConfiguration getCorsConfiguration(Object handler, ServerWebExchange exchange) {
        return super.getCorsConfiguration(handler, exchange);
    }

    private String getExchangeDesc(ServerWebExchange exchange) {
        StringBuilder out = new StringBuilder();
        out.append("Exchange: ");
        out.append(exchange.getRequest().getMethod());
        out.append(" ");
        out.append(exchange.getRequest().getURI());
        return out.toString();
    }

    protected Mono<Route> lookupRoute(ServerWebExchange exchange) {
        return this.routeLocator.getRoutes().filterWhen(route -> {
            exchange.getAttributes().put(ServerWebExchangeUtils.GATEWAY_PREDICATE_ROUTE_ATTR, route.getId());
            return (Publisher)route.getPredicate().apply(exchange);
        }).next().map(route -> {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Route matched: " + route.getId()));
            }
            this.validateRoute((Route)route, exchange);
            return route;
        });
    }

    protected void validateRoute(Route route, ServerWebExchange exchange) {
    }
}

