/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.filter;

import io.netty.handler.codec.http.DefaultHttpHeaders;
import io.netty.handler.codec.http.HttpMethod;
import java.net.URI;
import java.util.List;
import java.util.Map;
import org.reactivestreams.Publisher;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.cloud.gateway.filter.GatewayFilterChain;
import org.springframework.cloud.gateway.filter.GlobalFilter;
import org.springframework.cloud.gateway.filter.headers.HttpHeadersFilter;
import org.springframework.cloud.gateway.support.ServerWebExchangeUtils;
import org.springframework.core.Ordered;
import org.springframework.core.io.buffer.NettyDataBuffer;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.server.reactive.AbstractServerHttpResponse;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.http.server.reactive.ServerHttpResponse;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;
import reactor.ipc.netty.NettyPipeline;
import reactor.ipc.netty.http.client.HttpClient;
import reactor.ipc.netty.http.client.HttpClientRequest;

public class NettyRoutingFilter
implements GlobalFilter,
Ordered {
    private final HttpClient httpClient;
    private final ObjectProvider<List<HttpHeadersFilter>> headersFilters;

    public NettyRoutingFilter(HttpClient httpClient, ObjectProvider<List<HttpHeadersFilter>> headersFilters) {
        this.httpClient = httpClient;
        this.headersFilters = headersFilters;
    }

    public int getOrder() {
        return Integer.MAX_VALUE;
    }

    @Override
    public Mono<Void> filter(ServerWebExchange exchange, GatewayFilterChain chain) {
        URI requestUrl = (URI)exchange.getRequiredAttribute(ServerWebExchangeUtils.GATEWAY_REQUEST_URL_ATTR);
        String scheme = requestUrl.getScheme();
        if (ServerWebExchangeUtils.isAlreadyRouted(exchange) || !"http".equals(scheme) && !"https".equals(scheme)) {
            return chain.filter(exchange);
        }
        ServerWebExchangeUtils.setAlreadyRouted(exchange);
        ServerHttpRequest request = exchange.getRequest();
        HttpMethod method = HttpMethod.valueOf((String)request.getMethod().toString());
        String url = requestUrl.toString();
        HttpHeaders filtered = HttpHeadersFilter.filterRequest((List)this.headersFilters.getIfAvailable(), exchange);
        DefaultHttpHeaders httpHeaders = new DefaultHttpHeaders();
        filtered.forEach((arg_0, arg_1) -> ((DefaultHttpHeaders)httpHeaders).set(arg_0, arg_1));
        String transferEncoding = request.getHeaders().getFirst("Transfer-Encoding");
        boolean chunkedTransfer = "chunked".equalsIgnoreCase(transferEncoding);
        boolean preserveHost = (Boolean)exchange.getAttributeOrDefault(ServerWebExchangeUtils.PRESERVE_HOST_HEADER_ATTRIBUTE, (Object)false);
        return this.httpClient.request(method, url, req -> {
            HttpClientRequest proxyRequest = req.options(NettyPipeline.SendOptions::flushOnEach).headers((io.netty.handler.codec.http.HttpHeaders)httpHeaders).chunkedTransfer(chunkedTransfer).failOnServerError(false).failOnClientError(false);
            if (preserveHost) {
                String host = request.getHeaders().getFirst("Host");
                proxyRequest.header((CharSequence)"Host", (CharSequence)host);
            }
            return proxyRequest.sendHeaders().send((Publisher)request.getBody().map(dataBuffer -> ((NettyDataBuffer)dataBuffer).getNativeBuffer()));
        }).doOnNext(res -> {
            ServerHttpResponse response = exchange.getResponse();
            HttpHeaders headers = new HttpHeaders();
            res.responseHeaders().forEach(entry -> headers.add((String)entry.getKey(), (String)entry.getValue()));
            exchange.getAttributes().put("original_response_content_type", headers.getContentType());
            HttpHeaders filteredResponseHeaders = HttpHeadersFilter.filter((List)this.headersFilters.getIfAvailable(), headers, exchange, HttpHeadersFilter.Type.RESPONSE);
            response.getHeaders().putAll((Map)filteredResponseHeaders);
            HttpStatus status = HttpStatus.resolve((int)res.status().code());
            if (status != null) {
                response.setStatusCode(status);
            } else if (response instanceof AbstractServerHttpResponse) {
                ((AbstractServerHttpResponse)response).setStatusCodeValue(Integer.valueOf(res.status().code()));
            } else {
                throw new IllegalStateException("Unable to set status code on response: " + res.status().code() + ", " + response.getClass());
            }
            exchange.getAttributes().put(ServerWebExchangeUtils.CLIENT_RESPONSE_ATTR, res);
        }).then(chain.filter(exchange));
    }
}

