/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.consul;

import com.ecwid.consul.transport.TLSConfig;
import com.ecwid.consul.v1.ConsulClient;
import org.aspectj.lang.annotation.Aspect;
import org.springframework.boot.actuate.autoconfigure.endpoint.condition.ConditionalOnAvailableEndpoint;
import org.springframework.boot.actuate.autoconfigure.health.ConditionalOnEnabledHealthIndicator;
import org.springframework.boot.actuate.endpoint.annotation.Endpoint;
import org.springframework.boot.autoconfigure.aop.AopAutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.consul.ConditionalOnConsulEnabled;
import org.springframework.cloud.consul.ConsulEndpoint;
import org.springframework.cloud.consul.ConsulHealthIndicator;
import org.springframework.cloud.consul.ConsulHealthIndicatorProperties;
import org.springframework.cloud.consul.ConsulProperties;
import org.springframework.cloud.consul.RetryProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.retry.annotation.EnableRetry;
import org.springframework.retry.annotation.Retryable;
import org.springframework.retry.interceptor.RetryInterceptorBuilder;
import org.springframework.retry.interceptor.RetryOperationsInterceptor;
import org.springframework.util.StringUtils;

@Configuration(proxyBeanMethods=false)
@EnableConfigurationProperties
@ConditionalOnConsulEnabled
public class ConsulAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    public ConsulProperties consulProperties() {
        return new ConsulProperties();
    }

    @Bean
    @ConditionalOnMissingBean
    public ConsulClient consulClient(ConsulProperties consulProperties) {
        return ConsulAutoConfiguration.createConsulClient(consulProperties);
    }

    public static ConsulClient createConsulClient(ConsulProperties consulProperties) {
        String agentHost;
        int agentPort = consulProperties.getPort();
        String string = agentHost = !StringUtils.isEmpty((Object)consulProperties.getScheme()) ? consulProperties.getScheme() + "://" + consulProperties.getHost() : consulProperties.getHost();
        if (consulProperties.getTls() != null) {
            ConsulProperties.TLSConfig tls = consulProperties.getTls();
            TLSConfig tlsConfig = new TLSConfig(tls.getKeyStoreInstanceType(), tls.getCertificatePath(), tls.getCertificatePassword(), tls.getKeyStorePath(), tls.getKeyStorePassword());
            return new ConsulClient(agentHost, agentPort, tlsConfig);
        }
        return new ConsulClient(agentHost, agentPort);
    }

    @ConditionalOnClass(value={Retryable.class, Aspect.class, AopAutoConfiguration.class})
    @Configuration(proxyBeanMethods=false)
    @EnableRetry(proxyTargetClass=true)
    @Import(value={AopAutoConfiguration.class})
    @EnableConfigurationProperties(value={RetryProperties.class})
    @ConditionalOnProperty(value={"spring.cloud.consul.retry.enabled"}, matchIfMissing=true)
    protected static class RetryConfiguration {
        protected RetryConfiguration() {
        }

        @Bean(name={"consulRetryInterceptor"})
        @ConditionalOnMissingBean(name={"consulRetryInterceptor"})
        public RetryOperationsInterceptor consulRetryInterceptor(RetryProperties properties) {
            return (RetryOperationsInterceptor)RetryInterceptorBuilder.stateless().backOffOptions(properties.getInitialInterval(), properties.getMultiplier(), properties.getMaxInterval()).maxAttempts(properties.getMaxAttempts()).build();
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(value={Endpoint.class})
    @EnableConfigurationProperties(value={ConsulHealthIndicatorProperties.class})
    protected static class ConsulHealthConfig {
        protected ConsulHealthConfig() {
        }

        @Bean
        @ConditionalOnMissingBean
        @ConditionalOnAvailableEndpoint
        public ConsulEndpoint consulEndpoint(ConsulClient consulClient) {
            return new ConsulEndpoint(consulClient);
        }

        @Bean
        @ConditionalOnMissingBean
        @ConditionalOnEnabledHealthIndicator(value="consul")
        public ConsulHealthIndicator consulHealthIndicator(ConsulClient consulClient, ConsulHealthIndicatorProperties properties) {
            return new ConsulHealthIndicator(consulClient, properties);
        }
    }
}

