/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.consul;

import com.ecwid.consul.v1.ConsulClient;
import com.ecwid.consul.v1.QueryParams;
import com.ecwid.consul.v1.Response;
import com.ecwid.consul.v1.catalog.CatalogServicesRequest;
import org.springframework.boot.actuate.health.AbstractHealthIndicator;
import org.springframework.boot.actuate.health.Health;

public class ConsulHealthIndicator
extends AbstractHealthIndicator {
    private ConsulClient consul;

    public ConsulHealthIndicator(ConsulClient consul) {
        this.consul = consul;
    }

    protected void doHealthCheck(Health.Builder builder) throws Exception {
        Response leaderStatus = this.consul.getStatusLeader();
        Response services = this.consul.getCatalogServices(CatalogServicesRequest.newBuilder().setQueryParams(QueryParams.DEFAULT).build());
        builder.up().withDetail("leader", leaderStatus.getValue()).withDetail("services", services.getValue());
    }
}

