/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.alibaba.dubbo.service;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.dubbo.common.URL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.alibaba.dubbo.metadata.ServiceRestMetadata;
import org.springframework.cloud.alibaba.dubbo.metadata.repository.DubboServiceMetadataRepository;
import org.springframework.cloud.alibaba.dubbo.service.DubboMetadataService;
import org.springframework.cloud.alibaba.dubbo.util.JSONUtils;
import org.springframework.util.CollectionUtils;

public class IntrospectiveDubboMetadataService
implements DubboMetadataService {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private ObjectProvider<DubboServiceMetadataRepository> dubboServiceMetadataRepository;
    @Autowired
    private JSONUtils jsonUtils;

    @Override
    public String getServiceRestMetadata() {
        Set<ServiceRestMetadata> serviceRestMetadata = this.getRepository().getServiceRestMetadata();
        String serviceRestMetadataJsonConfig = null;
        if (!CollectionUtils.isEmpty(serviceRestMetadata)) {
            serviceRestMetadataJsonConfig = this.jsonUtils.toJSON(serviceRestMetadata);
        }
        return serviceRestMetadataJsonConfig;
    }

    @Override
    public Set<String> getAllServiceKeys() {
        return this.getRepository().getAllServiceKeys();
    }

    @Override
    public Map<String, String> getAllExportedURLs() {
        Map<String, List<URL>> allExportedUrls = this.getRepository().getAllExportedUrls();
        if (CollectionUtils.isEmpty(allExportedUrls)) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("There is no registered URL.");
            }
            return Collections.emptyMap();
        }
        HashMap result = new HashMap();
        allExportedUrls.forEach((serviceKey, urls) -> result.put(serviceKey, this.jsonUtils.toJSON((Collection<URL>)urls)));
        return Collections.unmodifiableMap(result);
    }

    @Override
    public String getExportedURLs(String serviceInterface, String group, String version) {
        List<URL> urls = this.getRepository().getExportedURLs(serviceInterface, group, version);
        return this.jsonUtils.toJSON(urls);
    }

    private DubboServiceMetadataRepository getRepository() {
        return (DubboServiceMetadataRepository)this.dubboServiceMetadataRepository.getIfAvailable();
    }
}

