/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.alibaba.dubbo.metadata.resolver;

import java.lang.annotation.Annotation;
import java.util.LinkedHashMap;
import java.util.Map;
import org.springframework.cloud.alibaba.dubbo.annotation.DubboTransported;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.core.env.PropertyResolver;

public class DubboTransportedAttributesResolver {
    private final PropertyResolver propertyResolver;

    public DubboTransportedAttributesResolver(PropertyResolver propertyResolver) {
        this.propertyResolver = propertyResolver;
    }

    public Map<String, Object> resolve(DubboTransported dubboTransported) {
        Map attributes = AnnotationUtils.getAnnotationAttributes((Annotation)dubboTransported);
        return this.resolve(attributes);
    }

    public Map<String, Object> resolve(Map<String, Object> attributes) {
        LinkedHashMap<String, Object> resolvedAttributes = new LinkedHashMap<String, Object>();
        for (Map.Entry<String, Object> entry : attributes.entrySet()) {
            Object value = entry.getValue();
            if (value instanceof String) {
                value = this.propertyResolver.resolvePlaceholders(value.toString());
            }
            resolvedAttributes.put(entry.getKey(), value);
        }
        return resolvedAttributes;
    }
}

