/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.alibaba.dubbo.http.util;

import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.http.HttpRequest;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;

public abstract class HttpUtils {
    private static final String UTF_8 = "UTF-8";
    private static final String EQUAL = "=";
    private static final String AND = "&";
    private static final String SEMICOLON = ";";
    private static final String QUESTION_MASK = "?";
    private static final String EMPTY_VALUE = "";

    public static String normalizePath(String path) {
        if (!StringUtils.hasText((String)path)) {
            return path;
        }
        String normalizedPath = path;
        int index = normalizedPath.indexOf(QUESTION_MASK);
        if (index > -1) {
            normalizedPath = normalizedPath.substring(0, index);
        }
        return StringUtils.replace((String)normalizedPath, (String)"//", (String)"/");
    }

    public static MultiValueMap<String, String> getParameters(HttpRequest request) {
        URI uri = request.getURI();
        return HttpUtils.getParameters(uri.getQuery());
    }

    public static MultiValueMap<String, String> getParameters(String queryString) {
        return HttpUtils.getParameters(StringUtils.delimitedListToStringArray((String)queryString, (String)AND));
    }

    public static MultiValueMap<String, String> getParameters(Iterable<String> pairs) {
        LinkedMultiValueMap parameters = new LinkedMultiValueMap();
        if (pairs != null) {
            for (String pair : pairs) {
                String[] nameAndValue = StringUtils.delimitedListToStringArray((String)pair, (String)EQUAL);
                String name = HttpUtils.decode(nameAndValue[0]);
                String value = nameAndValue.length < 2 ? null : nameAndValue[1];
                value = HttpUtils.decode(value);
                HttpUtils.addParam((MultiValueMap<String, String>)parameters, name, value);
            }
        }
        return parameters;
    }

    public static MultiValueMap<String, String> getParameters(String ... pairs) {
        return HttpUtils.getParameters(Arrays.asList(pairs));
    }

    public static Set<String> toNameAndValuesSet(Map<String, List<String>> nameAndValuesMap) {
        LinkedHashSet<String> nameAndValues = new LinkedHashSet<String>();
        for (Map.Entry<String, List<String>> entry : nameAndValuesMap.entrySet()) {
            String name = entry.getKey();
            List<String> values = entry.getValue();
            for (String value : values) {
                String nameAndValue = name + EQUAL + value;
                nameAndValues.add(nameAndValue);
            }
        }
        return nameAndValues;
    }

    public static String[] toNameAndValues(Map<String, List<String>> nameAndValuesMap) {
        return HttpUtils.toNameAndValuesSet(nameAndValuesMap).toArray(new String[0]);
    }

    public static String toQueryString(Map<String, List<String>> params) {
        StringBuilder builder = new StringBuilder();
        for (String line : HttpUtils.toNameAndValuesSet(params)) {
            builder.append(line).append(AND);
        }
        return builder.toString();
    }

    public static String decode(String value) {
        if (value == null) {
            return value;
        }
        String decodedValue = value;
        try {
            decodedValue = URLDecoder.decode(value, UTF_8);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return decodedValue;
    }

    public static String encode(String value) {
        String encodedValue = value;
        try {
            encodedValue = URLEncoder.encode(value, UTF_8);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return encodedValue;
    }

    private static void addParam(MultiValueMap<String, String> paramsMap, String name, String value) {
        String paramValue = StringUtils.trimAllWhitespace((String)value);
        if (!StringUtils.hasText((String)paramValue)) {
            paramValue = EMPTY_VALUE;
        }
        paramsMap.add((Object)StringUtils.trimAllWhitespace((String)name), (Object)paramValue);
    }
}

