/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.alibaba.dubbo.env;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.dubbo.config.spring.util.PropertySourcesUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.WebApplicationType;
import org.springframework.boot.env.EnvironmentPostProcessor;
import org.springframework.core.Ordered;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.core.env.PropertySource;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public class DubboNonWebApplicationEnvironmentPostProcessor
implements EnvironmentPostProcessor,
Ordered {
    private static final String DOT = ".";
    private static final String PROPERTY_SOURCE_NAME = "defaultProperties";
    private static final String SERVER_PORT_PROPERTY_NAME = "server.port";
    private static final String PORT_PROPERTY_NAME = "port";
    private static final String PROTOCOL_PROPERTY_NAME_PREFIX = "dubbo.protocol";
    private static final String PROTOCOL_NAME_PROPERTY_NAME_SUFFIX = ".name";
    private static final String PROTOCOL_PORT_PROPERTY_NAME_SUFFIX = ".port";
    private static final String PROTOCOL_PORT_PROPERTY_NAME = "dubbo.protocol.port";
    private static final String PROTOCOL_NAME_PROPERTY_NAME = "dubbo.protocol.name";
    private static final String PROTOCOLS_PROPERTY_NAME_PREFIX = "dubbo.protocols";
    private static final String REST_PROTOCOL = "rest";
    private final Logger logger = LoggerFactory.getLogger(DubboNonWebApplicationEnvironmentPostProcessor.class);

    public void postProcessEnvironment(ConfigurableEnvironment environment, SpringApplication application) {
        WebApplicationType webApplicationType = application.getWebApplicationType();
        if (!WebApplicationType.NONE.equals((Object)webApplicationType)) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Current application is a Web Application, the process will be ignored.");
            }
            return;
        }
        MutablePropertySources propertySources = environment.getPropertySources();
        Map<String, Object> defaultProperties = this.createDefaultProperties(environment);
        if (!CollectionUtils.isEmpty(defaultProperties)) {
            this.addOrReplace(propertySources, defaultProperties);
        }
    }

    private Map<String, Object> createDefaultProperties(ConfigurableEnvironment environment) {
        HashMap<String, Object> defaultProperties = new HashMap<String, Object>();
        this.resetServerPort(environment, defaultProperties);
        return defaultProperties;
    }

    private void resetServerPort(ConfigurableEnvironment environment, Map<String, Object> defaultProperties) {
        String serverPort = environment.getProperty(SERVER_PORT_PROPERTY_NAME, environment.getProperty(PORT_PROPERTY_NAME));
        if (serverPort != null) {
            return;
        }
        serverPort = this.getRestPortFromProtocolProperty(environment);
        if (serverPort == null) {
            serverPort = this.getRestPortFromProtocolsProperties(environment);
        }
        this.setServerPort(environment, serverPort, defaultProperties);
    }

    private String getRestPortFromProtocolProperty(ConfigurableEnvironment environment) {
        String protocol = environment.getProperty(PROTOCOL_NAME_PROPERTY_NAME, "dubbo");
        return DubboNonWebApplicationEnvironmentPostProcessor.isRestProtocol(protocol) ? environment.getProperty(PROTOCOL_PORT_PROPERTY_NAME) : null;
    }

    private String getRestPortFromProtocolsProperties(ConfigurableEnvironment environment) {
        String restPort = null;
        Map subProperties = PropertySourcesUtils.getSubProperties((ConfigurableEnvironment)environment, (String)PROTOCOLS_PROPERTY_NAME_PREFIX);
        Properties properties = new Properties();
        properties.putAll((Map<?, ?>)subProperties);
        for (String propertyName : properties.stringPropertyNames()) {
            String beanName;
            String protocol;
            if (!propertyName.endsWith(PROTOCOL_NAME_PROPERTY_NAME_SUFFIX) || !DubboNonWebApplicationEnvironmentPostProcessor.isRestProtocol(protocol = properties.getProperty(propertyName)) || !StringUtils.hasText((String)(beanName = this.resolveBeanName(propertyName)))) continue;
            restPort = properties.getProperty(beanName + PROTOCOL_PORT_PROPERTY_NAME_SUFFIX);
            break;
        }
        return restPort;
    }

    private String resolveBeanName(String propertyName) {
        int index = propertyName.indexOf(DOT);
        return index > -1 ? propertyName.substring(0, index) : null;
    }

    private void setServerPort(ConfigurableEnvironment environment, String serverPort, Map<String, Object> defaultProperties) {
        if (serverPort == null) {
            return;
        }
        defaultProperties.put(SERVER_PORT_PROPERTY_NAME, serverPort);
    }

    private void addOrReplace(MutablePropertySources propertySources, Map<String, Object> map) {
        PropertySource source;
        MapPropertySource target = null;
        if (propertySources.contains(PROPERTY_SOURCE_NAME) && (source = propertySources.get(PROPERTY_SOURCE_NAME)) instanceof MapPropertySource) {
            target = (MapPropertySource)source;
            for (String key : map.keySet()) {
                if (target.containsProperty(key)) continue;
                ((Map)target.getSource()).put(key, map.get(key));
            }
        }
        if (target == null) {
            target = new MapPropertySource(PROPERTY_SOURCE_NAME, map);
        }
        if (!propertySources.contains(PROPERTY_SOURCE_NAME)) {
            propertySources.addLast((PropertySource)target);
        }
    }

    public int getOrder() {
        return Integer.MAX_VALUE;
    }

    private static boolean isRestProtocol(String protocol) {
        return REST_PROTOCOL.equalsIgnoreCase(protocol);
    }
}

