/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.alibaba.dubbo.client.loadbalancer;

import java.io.IOException;
import java.net.URI;
import java.util.List;
import java.util.Map;
import org.apache.dubbo.rpc.service.GenericException;
import org.apache.dubbo.rpc.service.GenericService;
import org.springframework.cloud.alibaba.dubbo.client.loadbalancer.DubboClientHttpResponseFactory;
import org.springframework.cloud.alibaba.dubbo.http.MutableHttpServerRequest;
import org.springframework.cloud.alibaba.dubbo.metadata.DubboRestServiceMetadata;
import org.springframework.cloud.alibaba.dubbo.metadata.RequestMetadata;
import org.springframework.cloud.alibaba.dubbo.metadata.RestMethodMetadata;
import org.springframework.cloud.alibaba.dubbo.metadata.repository.DubboServiceMetadataRepository;
import org.springframework.cloud.alibaba.dubbo.service.DubboGenericServiceExecutionContext;
import org.springframework.cloud.alibaba.dubbo.service.DubboGenericServiceExecutionContextFactory;
import org.springframework.cloud.alibaba.dubbo.service.DubboGenericServiceFactory;
import org.springframework.http.HttpRequest;
import org.springframework.http.client.ClientHttpRequestExecution;
import org.springframework.http.client.ClientHttpRequestInterceptor;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.util.AntPathMatcher;
import org.springframework.util.CollectionUtils;
import org.springframework.util.PathMatcher;
import org.springframework.web.util.UriComponents;
import org.springframework.web.util.UriComponentsBuilder;

public class DubboTransporterInterceptor
implements ClientHttpRequestInterceptor {
    private final DubboServiceMetadataRepository repository;
    private final DubboClientHttpResponseFactory clientHttpResponseFactory;
    private final Map<String, Object> dubboTranslatedAttributes;
    private final DubboGenericServiceFactory serviceFactory;
    private final DubboGenericServiceExecutionContextFactory contextFactory;
    private final PathMatcher pathMatcher = new AntPathMatcher();

    public DubboTransporterInterceptor(DubboServiceMetadataRepository dubboServiceMetadataRepository, List<HttpMessageConverter<?>> messageConverters, ClassLoader classLoader, Map<String, Object> dubboTranslatedAttributes, DubboGenericServiceFactory serviceFactory, DubboGenericServiceExecutionContextFactory contextFactory) {
        this.repository = dubboServiceMetadataRepository;
        this.dubboTranslatedAttributes = dubboTranslatedAttributes;
        this.clientHttpResponseFactory = new DubboClientHttpResponseFactory(messageConverters, classLoader);
        this.serviceFactory = serviceFactory;
        this.contextFactory = contextFactory;
    }

    public ClientHttpResponse intercept(HttpRequest request, byte[] body, ClientHttpRequestExecution execution) throws IOException {
        RequestMetadata clientMetadata;
        URI originalUri = request.getURI();
        String serviceName = originalUri.getHost();
        DubboRestServiceMetadata metadata = this.repository.get(serviceName, clientMetadata = this.buildRequestMetadata(request));
        if (metadata == null) {
            return execution.execute(request, body);
        }
        RestMethodMetadata dubboRestMethodMetadata = metadata.getRestMethodMetadata();
        GenericService genericService = this.serviceFactory.create(metadata, this.dubboTranslatedAttributes);
        MutableHttpServerRequest httpServerRequest = new MutableHttpServerRequest(request, body);
        this.customizeRequest(httpServerRequest, dubboRestMethodMetadata, clientMetadata);
        DubboGenericServiceExecutionContext context = this.contextFactory.create(dubboRestMethodMetadata, httpServerRequest);
        Object result = null;
        GenericException exception = null;
        try {
            result = genericService.$invoke(context.getMethodName(), context.getParameterTypes(), context.getParameters());
        }
        catch (GenericException e) {
            exception = e;
        }
        return this.clientHttpResponseFactory.build(result, exception, clientMetadata, dubboRestMethodMetadata);
    }

    protected void customizeRequest(MutableHttpServerRequest httpServerRequest, RestMethodMetadata dubboRestMethodMetadata, RequestMetadata clientMetadata) {
        RequestMetadata dubboRequestMetadata = dubboRestMethodMetadata.getRequest();
        String pathPattern = dubboRequestMetadata.getPath();
        Map pathVariables = this.pathMatcher.extractUriTemplateVariables(pathPattern, httpServerRequest.getPath());
        if (!CollectionUtils.isEmpty((Map)pathVariables)) {
            httpServerRequest.params(pathVariables);
        }
    }

    private RequestMetadata buildRequestMetadata(HttpRequest request) {
        UriComponents uriComponents = UriComponentsBuilder.fromUri((URI)request.getURI()).build(true);
        RequestMetadata requestMetadata = new RequestMetadata();
        requestMetadata.setPath(uriComponents.getPath());
        requestMetadata.setMethod(request.getMethod().name());
        requestMetadata.setParams((Map<String, List<String>>)uriComponents.getQueryParams());
        requestMetadata.setHeaders((Map<String, List<String>>)request.getHeaders());
        return requestMetadata;
    }
}

