/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.alibaba.dubbo.metadata;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.springframework.cloud.alibaba.dubbo.metadata.MethodMetadata;
import org.springframework.cloud.alibaba.dubbo.metadata.RequestMetadata;
import org.springframework.core.ResolvableType;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class RestMethodMetadata {
    private MethodMetadata method;
    private RequestMetadata request;
    @JsonProperty(value="url-index")
    private Integer urlIndex;
    @JsonProperty(value="setBody-index")
    private Integer bodyIndex;
    @JsonProperty(value="header-map-index")
    private Integer headerMapIndex;
    @JsonProperty(value="query-map-index")
    private Integer queryMapIndex;
    @JsonProperty(value="query-map-encoded")
    private boolean queryMapEncoded;
    @JsonProperty(value="return-type")
    private String returnType;
    @JsonProperty(value="setBody-type")
    private String bodyType;
    @JsonProperty(value="index-to-name")
    private Map<Integer, Collection<String>> indexToName;
    @JsonProperty(value="form-params")
    private List<String> formParams;
    @JsonProperty(value="index-to-encoded")
    private Map<Integer, Boolean> indexToEncoded;

    public RestMethodMetadata() {
    }

    public RestMethodMetadata(feign.MethodMetadata methodMetadata) {
        this.request = new RequestMetadata(methodMetadata.template());
        this.urlIndex = methodMetadata.urlIndex();
        this.bodyIndex = methodMetadata.bodyIndex();
        this.headerMapIndex = methodMetadata.headerMapIndex();
        this.queryMapEncoded = methodMetadata.queryMapEncoded();
        this.queryMapEncoded = methodMetadata.queryMapEncoded();
        this.returnType = this.getClassName(methodMetadata.returnType());
        this.bodyType = this.getClassName(methodMetadata.bodyType());
        this.indexToName = methodMetadata.indexToName();
        this.formParams = methodMetadata.formParams();
        this.indexToEncoded = methodMetadata.indexToEncoded();
    }

    public MethodMetadata getMethod() {
        return this.method;
    }

    public void setMethod(MethodMetadata method) {
        this.method = method;
    }

    public RequestMetadata getRequest() {
        return this.request;
    }

    public void setRequest(RequestMetadata request) {
        this.request = request;
    }

    public Map<Integer, Collection<String>> getIndexToName() {
        return this.indexToName;
    }

    public void setIndexToName(Map<Integer, Collection<String>> indexToName) {
        this.indexToName = indexToName;
    }

    public Integer getUrlIndex() {
        return this.urlIndex;
    }

    public void setUrlIndex(Integer urlIndex) {
        this.urlIndex = urlIndex;
    }

    public Integer getBodyIndex() {
        return this.bodyIndex;
    }

    public void setBodyIndex(Integer bodyIndex) {
        this.bodyIndex = bodyIndex;
    }

    public Integer getHeaderMapIndex() {
        return this.headerMapIndex;
    }

    public void setHeaderMapIndex(Integer headerMapIndex) {
        this.headerMapIndex = headerMapIndex;
    }

    public Integer getQueryMapIndex() {
        return this.queryMapIndex;
    }

    public void setQueryMapIndex(Integer queryMapIndex) {
        this.queryMapIndex = queryMapIndex;
    }

    public boolean isQueryMapEncoded() {
        return this.queryMapEncoded;
    }

    public void setQueryMapEncoded(boolean queryMapEncoded) {
        this.queryMapEncoded = queryMapEncoded;
    }

    public String getReturnType() {
        return this.returnType;
    }

    public void setReturnType(String returnType) {
        this.returnType = returnType;
    }

    public String getBodyType() {
        return this.bodyType;
    }

    public void setBodyType(String bodyType) {
        this.bodyType = bodyType;
    }

    public List<String> getFormParams() {
        return this.formParams;
    }

    public void setFormParams(List<String> formParams) {
        this.formParams = formParams;
    }

    public Map<Integer, Boolean> getIndexToEncoded() {
        return this.indexToEncoded;
    }

    public void setIndexToEncoded(Map<Integer, Boolean> indexToEncoded) {
        this.indexToEncoded = indexToEncoded;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RestMethodMetadata)) {
            return false;
        }
        RestMethodMetadata that = (RestMethodMetadata)o;
        return this.queryMapEncoded == that.queryMapEncoded && Objects.equals(this.method, that.method) && Objects.equals(this.request, that.request) && Objects.equals(this.urlIndex, that.urlIndex) && Objects.equals(this.bodyIndex, that.bodyIndex) && Objects.equals(this.headerMapIndex, that.headerMapIndex) && Objects.equals(this.queryMapIndex, that.queryMapIndex) && Objects.equals(this.returnType, that.returnType) && Objects.equals(this.bodyType, that.bodyType) && Objects.equals(this.indexToName, that.indexToName) && Objects.equals(this.formParams, that.formParams) && Objects.equals(this.indexToEncoded, that.indexToEncoded);
    }

    public int hashCode() {
        return Objects.hash(this.method, this.request, this.urlIndex, this.bodyIndex, this.headerMapIndex, this.queryMapIndex, this.queryMapEncoded, this.returnType, this.bodyType, this.indexToName, this.formParams, this.indexToEncoded);
    }

    private String getClassName(Type type) {
        if (type == null) {
            return null;
        }
        ResolvableType resolvableType = ResolvableType.forType((Type)type);
        return resolvableType.resolve().getName();
    }

    public String toString() {
        return "RestMethodMetadata{method=" + this.method + ", request=" + this.request + ", urlIndex=" + this.urlIndex + ", bodyIndex=" + this.bodyIndex + ", headerMapIndex=" + this.headerMapIndex + ", queryMapIndex=" + this.queryMapIndex + ", queryMapEncoded=" + this.queryMapEncoded + ", returnType='" + this.returnType + '\'' + ", bodyType='" + this.bodyType + '\'' + ", indexToName=" + this.indexToName + ", formParams=" + this.formParams + ", indexToEncoded=" + this.indexToEncoded + '}';
    }
}

