/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.alibaba.dubbo.http.matcher;

import org.springframework.cloud.alibaba.dubbo.http.matcher.AbstractNameValueExpression;
import org.springframework.cloud.alibaba.dubbo.http.util.HttpUtils;
import org.springframework.http.HttpRequest;
import org.springframework.util.MultiValueMap;
import org.springframework.util.ObjectUtils;

class ParamExpression
extends AbstractNameValueExpression<String> {
    ParamExpression(String expression) {
        super(expression);
    }

    @Override
    protected boolean isCaseSensitiveName() {
        return true;
    }

    @Override
    protected String parseValue(String valueExpression) {
        return valueExpression;
    }

    @Override
    protected boolean matchName(HttpRequest request) {
        MultiValueMap<String, String> parametersMap = HttpUtils.getParameters(request);
        return parametersMap.containsKey((Object)this.name);
    }

    @Override
    protected boolean matchValue(HttpRequest request) {
        MultiValueMap<String, String> parametersMap = HttpUtils.getParameters(request);
        String parameterValue = (String)parametersMap.getFirst((Object)this.name);
        return ObjectUtils.nullSafeEquals((Object)this.value, (Object)parameterValue);
    }
}

