/*
 * Decompiled with CFR 0.152.
 */
package org.redisson;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousByteChannel;
import java.nio.channels.CompletionHandler;
import java.nio.channels.SeekableByteChannel;
import java.util.Arrays;
import java.util.concurrent.Future;
import org.redisson.RedissonBucket;
import org.redisson.api.RBinaryStream;
import org.redisson.api.RFuture;
import org.redisson.client.codec.ByteArrayCodec;
import org.redisson.client.codec.Codec;
import org.redisson.client.codec.LongCodec;
import org.redisson.client.protocol.RedisCommands;
import org.redisson.command.CommandAsyncExecutor;
import org.redisson.misc.RedissonPromise;

public class RedissonBinaryStream
extends RedissonBucket<byte[]>
implements RBinaryStream {
    protected RedissonBinaryStream(CommandAsyncExecutor connectionManager, String name) {
        super(ByteArrayCodec.INSTANCE, connectionManager, name);
    }

    @Override
    public InputStream getInputStream() {
        return new RedissonInputStream();
    }

    @Override
    public OutputStream getOutputStream() {
        return new RedissonOutputStream();
    }

    @Override
    public SeekableByteChannel getChannel() {
        return new RedissonByteChannel();
    }

    @Override
    public AsynchronousByteChannel getAsynchronousChannel() {
        return new RedissonAsynchronousByteChannel();
    }

    public class RedissonAsynchronousByteChannel
    implements AsynchronousByteChannel {
        volatile int position;

        public long position() {
            return this.position;
        }

        public void position(long newPosition) {
            this.position = (int)newPosition;
        }

        @Override
        public <A> void read(ByteBuffer dst, A attachment, CompletionHandler<Integer, ? super A> handler) {
            RFuture res = (RFuture)this.read(dst);
            res.onComplete((r, e) -> {
                if (e != null) {
                    handler.failed((Throwable)e, (Object)attachment);
                } else {
                    handler.completed((Integer)r, (Object)attachment);
                }
            });
        }

        @Override
        public Future<Integer> read(ByteBuffer dst) {
            RedissonPromise<Integer> result = new RedissonPromise<Integer>();
            RFuture res = RedissonBinaryStream.this.commandExecutor.readAsync(RedissonBinaryStream.this.getName(), RedissonBinaryStream.this.codec, RedisCommands.GETRANGE, RedissonBinaryStream.this.getName(), this.position, this.position + dst.remaining() - 1);
            res.onComplete((data, e) -> {
                if (e != null) {
                    result.tryFailure((Throwable)e);
                    return;
                }
                if (((byte[])data).length == 0) {
                    result.trySuccess(-1);
                    return;
                }
                this.position += ((byte[])data).length;
                dst.put((byte[])data);
                result.trySuccess(((byte[])data).length);
            });
            return result;
        }

        @Override
        public <A> void write(ByteBuffer src, A attachment, CompletionHandler<Integer, ? super A> handler) {
            RFuture res = (RFuture)this.write(src);
            res.onComplete((r, e) -> {
                if (e != null) {
                    handler.failed((Throwable)e, (Object)attachment);
                } else {
                    handler.completed((Integer)r, (Object)attachment);
                }
            });
        }

        @Override
        public Future<Integer> write(ByteBuffer src) {
            RedissonPromise<Integer> result = new RedissonPromise<Integer>();
            ByteBuf b = Unpooled.wrappedBuffer((ByteBuffer)src);
            RFuture res = RedissonBinaryStream.this.commandExecutor.writeAsync(RedissonBinaryStream.this.getName(), RedissonBinaryStream.this.codec, RedisCommands.SETRANGE, RedissonBinaryStream.this.getName(), this.position, b);
            res.onComplete((r, e) -> {
                if (e != null) {
                    result.tryFailure((Throwable)e);
                    return;
                }
                this.position += b.readableBytes();
                result.trySuccess(b.readableBytes());
            });
            return result;
        }

        @Override
        public boolean isOpen() {
            return true;
        }

        @Override
        public void close() throws IOException {
        }
    }

    class RedissonByteChannel
    implements SeekableByteChannel {
        int position;

        RedissonByteChannel() {
        }

        @Override
        public int read(ByteBuffer dst) throws IOException {
            byte[] data = (byte[])RedissonBinaryStream.this.get(RedissonBinaryStream.this.commandExecutor.readAsync(RedissonBinaryStream.this.getName(), RedissonBinaryStream.this.codec, RedisCommands.GETRANGE, RedissonBinaryStream.this.getName(), this.position, this.position + dst.remaining() - 1));
            if (data.length == 0) {
                return -1;
            }
            this.position += data.length;
            dst.put(data);
            return data.length;
        }

        @Override
        public int write(ByteBuffer src) throws IOException {
            ByteBuf b = Unpooled.wrappedBuffer((ByteBuffer)src);
            RedissonBinaryStream.this.get(RedissonBinaryStream.this.commandExecutor.writeAsync(RedissonBinaryStream.this.getName(), RedissonBinaryStream.this.codec, RedisCommands.SETRANGE, RedissonBinaryStream.this.getName(), this.position, b));
            this.position += b.readableBytes();
            return b.readableBytes();
        }

        @Override
        public long position() throws IOException {
            return this.position;
        }

        @Override
        public SeekableByteChannel position(long newPosition) throws IOException {
            this.position = (int)newPosition;
            return this;
        }

        @Override
        public long size() throws IOException {
            return RedissonBinaryStream.this.size();
        }

        @Override
        public SeekableByteChannel truncate(long size) throws IOException {
            RedissonBinaryStream.this.get(RedissonBinaryStream.this.commandExecutor.evalWriteAsync(RedissonBinaryStream.this.getName(), (Codec)LongCodec.INSTANCE, RedisCommands.EVAL_VOID, "local len = redis.call('strlen', KEYS[1]); if tonumber(ARGV[1]) >= len then return;end;local limitedValue = redis.call('getrange', KEYS[1], 0, tonumber(ARGV[1])-1); redis.call('set', KEYS[1], limitedValue); ", Arrays.asList(RedissonBinaryStream.this.getName()), size));
            return this;
        }

        @Override
        public boolean isOpen() {
            return true;
        }

        @Override
        public void close() throws IOException {
        }
    }

    class RedissonInputStream
    extends InputStream {
        private int index;
        private int mark;

        RedissonInputStream() {
        }

        @Override
        public long skip(long n) throws IOException {
            long k = RedissonBinaryStream.this.size() - (long)this.index;
            if (n < k) {
                k = n;
                if (n < 0L) {
                    k = 0L;
                }
            }
            this.index = (int)((long)this.index + k);
            return k;
        }

        @Override
        public void mark(int readlimit) {
            this.mark = this.index;
        }

        @Override
        public void reset() throws IOException {
            this.index = this.mark;
        }

        @Override
        public int available() throws IOException {
            return (int)(RedissonBinaryStream.this.size() - (long)this.index);
        }

        @Override
        public boolean markSupported() {
            return true;
        }

        @Override
        public int read() throws IOException {
            byte[] b = new byte[1];
            int len = this.read(b);
            if (len == -1) {
                return -1;
            }
            return b[0] & 0xFF;
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            if (len == 0) {
                return 0;
            }
            if (b == null) {
                throw new NullPointerException();
            }
            if (off < 0 || len < 0 || len > b.length - off) {
                throw new IndexOutOfBoundsException();
            }
            byte[] data = (byte[])RedissonBinaryStream.this.get(RedissonBinaryStream.this.commandExecutor.readAsync(RedissonBinaryStream.this.getName(), RedissonBinaryStream.this.codec, RedisCommands.GETRANGE, RedissonBinaryStream.this.getName(), this.index, this.index + len - 1));
            if (data.length == 0) {
                return -1;
            }
            this.index += len;
            System.arraycopy(data, 0, b, off, data.length);
            return data.length;
        }
    }

    class RedissonOutputStream
    extends OutputStream {
        RedissonOutputStream() {
        }

        @Override
        public void write(int b) throws IOException {
            this.write(new byte[]{(byte)b});
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            byte[] dest;
            if (b.length == len && off == 0) {
                dest = b;
            } else {
                dest = new byte[len];
                System.arraycopy(b, off, dest, 0, len);
            }
            RedissonBinaryStream.this.get(RedissonBinaryStream.this.commandExecutor.writeAsync(RedissonBinaryStream.this.getName(), RedissonBinaryStream.this.codec, RedisCommands.APPEND, RedissonBinaryStream.this.getName(), dest));
        }
    }
}

