/*
 * Decompiled with CFR 0.152.
 */
package org.febit.wit_shaded.asm;

import org.febit.wit_shaded.asm.ByteBuffer;
import org.febit.wit_shaded.asm.ClassWriter;
import org.febit.wit_shaded.asm.Edge;
import org.febit.wit_shaded.asm.Item;
import org.febit.wit_shaded.asm.Label;

public final class MethodWriter {
    private final ClassWriter cw;
    private final int name;
    private final int desc;
    private final int access;
    private final int[] exceptions;
    private static final boolean computeMaxs = true;
    private int maxStack;
    private int maxLocals;
    private final ByteBuffer code = new ByteBuffer();
    private int catchCount;
    private ByteBuffer catchTable;
    private int localVarCount;
    private ByteBuffer localVar;
    private int stackSize;
    private int maxStackSize;
    private Label currentBlock;
    private Label blockStack;
    private static final int[] SIZE;
    private Edge head;
    private Edge tail;
    private static Edge pool;

    MethodWriter(ClassWriter classWriter, int n, String string, String string2, String[] stringArray) {
        int n2;
        this.cw = classWriter;
        this.access = n;
        this.name = classWriter.newUTF8(string);
        this.desc = classWriter.newUTF8(string2);
        if (stringArray != null && stringArray.length > 0) {
            n2 = stringArray.length;
            this.exceptions = new int[n2];
            for (int i = 0; i < n2; ++i) {
                this.exceptions[i] = classWriter.newClass(stringArray[i]);
            }
        } else {
            this.exceptions = ClassWriter.EMPATY_INTS;
        }
        this.blockStack = this.currentBlock = new Label();
        this.currentBlock.pushed = true;
        n2 = MethodWriter.getArgumentsAndReturnSizes(string2) >> 2;
        if ((n & 8) != 0) {
            --n2;
        }
        if (n2 > this.maxLocals) {
            this.maxLocals = n2;
        }
    }

    public void checkCast(String string) {
        if (!string.equals("java/lang/Object")) {
            this.visitTypeInsn(192, string);
        }
    }

    public void push(int n) {
        if (n > 0 && n <= 5) {
            this.visitInsn(3 + n);
        } else {
            this.visitLdcInsn(n);
        }
    }

    public void invokeStatic(String string, String string2, String string3) {
        this.visitMethodInsn(184, string, string2, string3);
    }

    public void invokeVirtual(String string, String string2, String string3) {
        this.visitMethodInsn(182, string, string2, string3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void visitMaxs() {
        Object object;
        int n = 0;
        Object object2 = this.blockStack;
        while (object2 != null) {
            object = object2;
            object2 = ((Label)object2).next;
            int n2 = ((Label)object).beginStackSize;
            int n3 = n2 + ((Label)object).maxStackSize;
            if (n3 > n) {
                n = n3;
            }
            Edge edge = ((Label)object).successors;
            while (edge != null) {
                object = edge.successor;
                if (!((Label)object).pushed) {
                    ((Label)object).beginStackSize = n2 + edge.stackSize;
                    ((Label)object).pushed = true;
                    ((Label)object).next = object2;
                    object2 = object;
                }
                edge = edge.next;
            }
        }
        this.maxStack = n;
        object = SIZE;
        synchronized (SIZE) {
            if (this.tail != null) {
                this.tail.poolNext = pool;
                pool = this.head;
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    public void visitInsn(int n) {
        int n2 = this.stackSize + SIZE[n];
        if (n2 > this.maxStackSize) {
            this.maxStackSize = n2;
        }
        this.stackSize = n2;
        if ((n >= 172 && n <= 177 || n == 191) && this.currentBlock != null) {
            this.currentBlock.maxStackSize = this.maxStackSize;
            this.currentBlock = null;
        }
        this.code.putByte(n);
    }

    public void visitVarInsn(int n, int n2) {
        int n3;
        ByteBuffer byteBuffer = this.code;
        if (n == 169) {
            if (this.currentBlock != null) {
                this.currentBlock.maxStackSize = this.maxStackSize;
                this.currentBlock = null;
            }
        } else {
            n3 = this.stackSize + SIZE[n];
            if (n3 > this.maxStackSize) {
                this.maxStackSize = n3;
            }
            this.stackSize = n3;
        }
        if ((n3 = n2 + 1) > this.maxLocals) {
            this.maxLocals = n3;
        }
        if (n2 < 4 && n != 169) {
            n3 = n < 54 ? 26 + (n - 21 << 2) + n2 : 59 + (n - 54 << 2) + n2;
            byteBuffer.putByte(n3);
        } else if (n2 >= 256) {
            byteBuffer.putByte(196).putBS(n, n2);
        } else {
            byteBuffer.putBB(n, n2);
        }
    }

    public void visitTypeInsn(int n, String string) {
        if (n == 187) {
            int n2 = this.stackSize + 1;
            if (n2 > this.maxStackSize) {
                this.maxStackSize = n2;
            }
            this.stackSize = n2;
        }
        this.code.putBS(n, this.cw.newClass(string));
    }

    public void visitFieldInsn(int n, String string, String string2, String string3) {
        int n2;
        char c = string3.charAt(0);
        switch (n) {
            case 178: {
                n2 = this.stackSize + (c == 'D' || c == 'J' ? 2 : 1);
                break;
            }
            case 180: {
                n2 = this.stackSize + (c == 'D' || c == 'J' ? 1 : 0);
                break;
            }
            default: {
                n2 = this.stackSize + (c == 'D' || c == 'J' ? -3 : -2);
            }
        }
        if (n2 > this.maxStackSize) {
            this.maxStackSize = n2;
        }
        this.stackSize = n2;
        this.code.putBS(n, this.cw.newField(string, string2, string3));
    }

    public void visitMethodInsn(int n, String string, String string2, String string3) {
        boolean bl = n == 185;
        Item item = this.cw.newMethodItem(string, string2, string3, bl);
        int n2 = item.argSize;
        if (n2 == 0) {
            item.argSize = n2 = MethodWriter.getArgumentsAndReturnSizes(string3);
        }
        int n3 = this.stackSize - (n2 >> 2) + (n2 & 3);
        if (n == 184) {
            ++n3;
        }
        if (n3 > this.maxStackSize) {
            this.maxStackSize = n3;
        }
        this.stackSize = n3;
        ByteBuffer byteBuffer = this.code;
        if (bl) {
            byteBuffer.putBS(185, item.index).putBB(n2 >> 2, 0);
        } else {
            byteBuffer.putBS(n, item.index);
        }
    }

    public void visitJumpInsn(int n, Label label) {
        ByteBuffer byteBuffer = this.code;
        if (n == 167) {
            if (this.currentBlock != null) {
                this.currentBlock.maxStackSize = this.maxStackSize;
                this.addSuccessor(this.stackSize, label);
                this.currentBlock = null;
            }
        } else if (n == 168) {
            if (this.currentBlock != null) {
                this.addSuccessor(this.stackSize + 1, label);
            }
        } else {
            this.stackSize += SIZE[n];
            if (this.currentBlock != null) {
                this.addSuccessor(this.stackSize, label);
            }
        }
        if (label.resolved && label.position - byteBuffer.length < Short.MIN_VALUE) {
            if (n == 167) {
                byteBuffer.putByte(200);
            } else if (n == 168) {
                byteBuffer.putByte(201);
            } else {
                byteBuffer.putByte(n <= 166 ? (n + 1 ^ 1) - 1 : n ^ 1).putShort(8).putByte(200);
            }
            label.put(this, byteBuffer, byteBuffer.length - 1, true);
        } else {
            byteBuffer.putByte(n);
            label.put(this, byteBuffer, byteBuffer.length - 1, false);
        }
    }

    public void visitLabel(Label label) {
        if (this.currentBlock != null) {
            this.currentBlock.maxStackSize = this.maxStackSize;
            this.addSuccessor(this.stackSize, label);
        }
        this.currentBlock = label;
        this.stackSize = 0;
        this.maxStackSize = 0;
        label.resolve(this, this.code.length, this.code.data);
    }

    public void visitLdcInsn(Object object) {
        Item item = this.cw.newConstItem(object);
        int n = this.stackSize += item.type == 5 || item.type == 6 ? 2 : 1;
        if (n > this.maxStackSize) {
            this.maxStackSize = n;
        }
        ByteBuffer byteBuffer = this.code;
        short s = item.index;
        if (item.type == 5 || item.type == 6) {
            byteBuffer.putBS(20, s);
        } else if (s >= 256) {
            byteBuffer.putBS(19, s);
        } else {
            byteBuffer.putBB(18, s);
        }
    }

    public void visitLookupSwitchInsn(Label label, int[] nArray, Label[] labelArray) {
        --this.stackSize;
        if (this.currentBlock != null) {
            this.currentBlock.maxStackSize = this.maxStackSize;
            this.addSuccessor(this.stackSize, label);
            for (int i = 0; i < labelArray.length; ++i) {
                this.addSuccessor(this.stackSize, labelArray[i]);
            }
            this.currentBlock = null;
        }
        ByteBuffer byteBuffer = this.code;
        int n = byteBuffer.length;
        byteBuffer.putByte(171);
        while (byteBuffer.length % 4 != 0) {
            byteBuffer.putByte(0);
        }
        label.put(this, byteBuffer, n, true);
        byteBuffer.putInt(labelArray.length);
        for (int i = 0; i < labelArray.length; ++i) {
            byteBuffer.putInt(nArray[i]);
            labelArray[i].put(this, byteBuffer, n, true);
        }
    }

    private static int getArgumentsAndReturnSizes(String string) {
        int n = 1;
        int n2 = 1;
        while (true) {
            char c;
            if ((c = string.charAt(n2++)) == ')') {
                c = string.charAt(n2);
                return n << 2 | (c == 'V' ? 0 : (c == 'D' || c == 'J' ? 2 : 1));
            }
            if (c == 'L') {
                while (string.charAt(n2++) != ';') {
                }
                ++n;
                continue;
            }
            if (c == '[') {
                while ((c = string.charAt(n2)) == '[') {
                    ++n2;
                }
                if (c != 'D' && c != 'J') continue;
                --n;
                continue;
            }
            if (c == 'D' || c == 'J') {
                n += 2;
                continue;
            }
            ++n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addSuccessor(int n, Label label) {
        int[] nArray = SIZE;
        synchronized (SIZE) {
            Edge edge;
            if (pool == null) {
                edge = new Edge();
            } else {
                edge = pool;
                pool = MethodWriter.pool.poolNext;
            }
            // ** MonitorExit[var4_3] (shouldn't be in output)
            if (this.tail == null) {
                this.tail = edge;
            }
            edge.poolNext = this.head;
            this.head = edge;
            edge.stackSize = n;
            edge.successor = label;
            edge.next = this.currentBlock.successors;
            this.currentBlock.successors = edge;
            return;
        }
    }

    final int getSize() {
        int n;
        int n2 = 8;
        if (this.code.length > 0) {
            this.cw.newUTF8("Code");
            n2 += 18 + this.code.length + 8 * this.catchCount;
            if (this.localVar != null) {
                n2 += 8 + this.localVar.length;
            }
        }
        if ((n = this.exceptions.length) > 0) {
            this.cw.newUTF8("Exceptions");
            n2 += 8 + 2 * n;
        }
        return n2;
    }

    final void renderTo(ByteBuffer byteBuffer) {
        int n;
        int n2;
        ByteBuffer byteBuffer2 = this.code;
        byteBuffer.putShort(this.access).putShort(this.name).putShort(this.desc);
        int n3 = 0;
        if (byteBuffer2.length > 0) {
            ++n3;
        }
        if ((n2 = this.exceptions.length) > 0) {
            ++n3;
        }
        byteBuffer.putShort(n3);
        if (byteBuffer2.length > 0) {
            n = 12 + byteBuffer2.length + 8 * this.catchCount;
            if (this.localVar != null) {
                n += 8 + this.localVar.length;
            }
            byteBuffer.putShort(this.cw.newUTF8("Code")).putInt(n).putShort(this.maxStack).putShort(this.maxLocals).putInt(byteBuffer2.length).put(byteBuffer2).putShort(this.catchCount);
            if (this.catchCount > 0) {
                byteBuffer.put(this.catchTable);
            }
            n3 = 0;
            if (this.localVar != null) {
                ++n3;
            }
            byteBuffer.putShort(n3);
            if (this.localVar != null) {
                byteBuffer.putShort(this.cw.newUTF8("LocalVariableTable")).putInt(this.localVar.length + 2).putShort(this.localVarCount).put(this.localVar);
            }
        }
        if (n2 > 0) {
            byteBuffer.putShort(this.cw.newUTF8("Exceptions")).putInt(2 * n2 + 2).putShort(n2);
            for (n = 0; n < n2; ++n) {
                byteBuffer.putShort(this.exceptions[n]);
            }
        }
    }

    static {
        int[] nArray = new int[202];
        String string = "EFFFFFFFFGGFFFGGFFFEEFGFGFEEEEEEEEEEEEEEEEEEEEDEDEDDDDDCDCDEEEEEEEEEEEEEEEEEEEEBABABBBBDCFFFGGGEDCDCDCDCDCDCDCDCDCDCEEEEDDDDDDDCDCDCEFEFDDEEFFDEDEEEBDDBBDDDDDDCCCCCCCCEFEDDDCDCDEEEEEEEEEEFEEEEEEDDEEDDEE";
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = string.charAt(i) - 69;
        }
        SIZE = nArray;
    }
}

