/*
 * Decompiled with CFR 0.152.
 */
package org.febit.wit_shaded.asm;

import org.febit.wit_shaded.asm.ByteBuffer;
import org.febit.wit_shaded.asm.Edge;
import org.febit.wit_shaded.asm.MethodWriter;

public final class Label {
    boolean resolved;
    int position;
    private int referenceCount;
    private int[] srcAndRefPositions;
    int beginStackSize;
    int maxStackSize;
    Edge successors;
    Label next;
    boolean pushed;

    void put(MethodWriter methodWriter, ByteBuffer byteBuffer, int n, boolean bl) {
        if (this.resolved) {
            if (bl) {
                byteBuffer.putInt(this.position - n);
            } else {
                byteBuffer.putShort(this.position - n);
            }
        } else if (bl) {
            this.addReference(-1 - n, byteBuffer.length);
            byteBuffer.putInt(-1);
        } else {
            this.addReference(n, byteBuffer.length);
            byteBuffer.putShort(-1);
        }
    }

    private void addReference(int n, int n2) {
        if (this.srcAndRefPositions == null) {
            this.srcAndRefPositions = new int[6];
        }
        if (this.referenceCount >= this.srcAndRefPositions.length) {
            int[] nArray = new int[this.srcAndRefPositions.length + 6];
            System.arraycopy(this.srcAndRefPositions, 0, nArray, 0, this.srcAndRefPositions.length);
            this.srcAndRefPositions = nArray;
        }
        this.srcAndRefPositions[this.referenceCount++] = n;
        this.srcAndRefPositions[this.referenceCount++] = n2;
    }

    void resolve(MethodWriter methodWriter, int n, byte[] byArray) {
        this.resolved = true;
        this.position = n;
        int n2 = 0;
        while (n2 < this.referenceCount) {
            int n3;
            int n4 = this.srcAndRefPositions[n2++];
            int n5 = this.srcAndRefPositions[n2++];
            if (n4 >= 0) {
                n3 = n - n4;
                if (n3 < Short.MIN_VALUE || n3 > Short.MAX_VALUE) {
                    throw new RuntimeException("label offset is more than 2 bytes:" + n3);
                }
                byArray[n5++] = (byte)(n3 >>> 8);
                byArray[n5] = (byte)n3;
                continue;
            }
            n3 = n + n4 + 1;
            byArray[n5++] = (byte)(n3 >>> 24);
            byArray[n5++] = (byte)(n3 >>> 16);
            byArray[n5++] = (byte)(n3 >>> 8);
            byArray[n5] = (byte)n3;
        }
    }
}

