/*
 * Decompiled with CFR 0.152.
 */
package org.febit.wit_shaded.asm;

import java.util.ArrayList;
import java.util.HashMap;
import org.febit.wit_shaded.asm.ByteBuffer;
import org.febit.wit_shaded.asm.Item;
import org.febit.wit_shaded.asm.MethodWriter;

public final class ClassWriter {
    static final int[] EMPATY_INTS = new int[0];
    static final int CLASS = 7;
    static final int FIELD = 9;
    static final int METH = 10;
    static final int IMETH = 11;
    static final int STR = 8;
    static final int INT = 3;
    static final int FLOAT = 4;
    static final int LONG = 5;
    static final int DOUBLE = 6;
    static final int NAME_TYPE = 12;
    static final int UTF8 = 1;
    private final int version;
    private final int access;
    private final int name;
    private final int superName;
    private final int[] interfaces;
    private final ArrayList<MethodWriter> methods;
    private final ByteBuffer pool = new ByteBuffer();
    private final HashMap<Item, Item> items = new HashMap(64);
    private short poolIndex = 1;
    private final Item key;
    private final Item key2;
    private final Item key3;

    public ClassWriter(int n, int n2, String string, String string2, String[] stringArray) {
        this.methods = new ArrayList();
        this.key = new Item();
        this.key2 = new Item();
        this.key3 = new Item();
        this.version = n;
        this.access = n2;
        this.name = this.newClass(string);
        int n3 = this.superName = string2 == null ? 0 : this.newClass(string2);
        if (stringArray != null) {
            int n4 = stringArray.length;
            this.interfaces = new int[n4];
            for (int i = 0; i < n4; ++i) {
                this.interfaces[i] = this.newClass(stringArray[i]);
            }
        } else {
            this.interfaces = EMPATY_INTS;
        }
    }

    public MethodWriter visitMethod(int n, String string, String string2, String[] stringArray) {
        MethodWriter methodWriter = new MethodWriter(this, n, string, string2, stringArray);
        this.methods.add(methodWriter);
        return methodWriter;
    }

    public byte[] toByteArray() {
        int n = this.interfaces.length;
        int n2 = 24 + 2 * n;
        for (MethodWriter methodWriter : this.methods) {
            n2 += methodWriter.getSize();
        }
        ByteBuffer byteBuffer = new ByteBuffer(n2 += this.pool.length);
        byteBuffer.putInt(-889275714).putInt(this.version);
        byteBuffer.putShort(this.poolIndex).put(this.pool);
        byteBuffer.putShort(this.access).putShort(this.name).putShort(this.superName);
        byteBuffer.putShort(n);
        for (int i = 0; i < n; ++i) {
            byteBuffer.putShort(this.interfaces[i]);
        }
        byteBuffer.putShort(0);
        byteBuffer.putShort(this.methods.size());
        for (MethodWriter methodWriter : this.methods) {
            methodWriter.renderTo(byteBuffer);
        }
        byteBuffer.putShort(0);
        return byteBuffer.data;
    }

    Item newConstItem(Object object) {
        if (object instanceof Integer) {
            return this.newInteger((Integer)object);
        }
        if (object instanceof Byte) {
            return this.newInteger(((Byte)object).byteValue());
        }
        if (object instanceof Character) {
            return this.newInteger(((Character)object).charValue());
        }
        if (object instanceof Short) {
            return this.newInteger(((Short)object).shortValue());
        }
        if (object instanceof Boolean) {
            return this.newInteger((Boolean)object != false ? 1 : 0);
        }
        if (object instanceof Float) {
            return this.newFloat(((Float)object).floatValue());
        }
        if (object instanceof Long) {
            return this.newLong((Long)object);
        }
        if (object instanceof Double) {
            return this.newDouble((Double)object);
        }
        if (object instanceof String) {
            return this.newString((String)object);
        }
        if (object instanceof Item) {
            return (Item)object;
        }
        throw new IllegalArgumentException("value " + object);
    }

    int newUTF8(String string) {
        Item item = this.get(this.key.set(1, string, null, null));
        if (item == null) {
            this.pool.putByte(1).putUTF8(string);
            short s = this.poolIndex;
            this.poolIndex = (short)(s + 1);
            item = new Item(s, this.key);
            this.put(item);
        }
        return item.index;
    }

    int newClass(String string) {
        return this.newClassItem((String)string).index;
    }

    Item newClassItem(String string) {
        Item item = this.get(this.key2.set(7, string, null, null));
        if (item == null) {
            this.pool.putBS(7, this.newUTF8(string));
            short s = this.poolIndex;
            this.poolIndex = (short)(s + 1);
            item = new Item(s, this.key2);
            this.put(item);
        }
        return item;
    }

    public int newField(String string, String string2, String string3) {
        Item item = this.get(this.key3.set(9, string, string2, string3));
        if (item == null) {
            this.put122(9, this.newClass(string), this.newNameType(string2, string3));
            short s = this.poolIndex;
            this.poolIndex = (short)(s + 1);
            item = new Item(s, this.key3);
            this.put(item);
        }
        return item.index;
    }

    Item newMethodItem(String string, String string2, String string3, boolean bl) {
        Item item = this.get(this.key3.set(bl ? 11 : 10, string, string2, string3));
        if (item == null) {
            this.put122(bl ? 11 : 10, this.newClass(string), this.newNameType(string2, string3));
            short s = this.poolIndex;
            this.poolIndex = (short)(s + 1);
            item = new Item(s, this.key3);
            this.put(item);
        }
        return item;
    }

    private Item newInteger(int n) {
        Item item = this.get(this.key.set(3, n));
        if (item == null) {
            this.pool.putByte(3).putInt(n);
            short s = this.poolIndex;
            this.poolIndex = (short)(s + 1);
            item = new Item(s, this.key);
            this.put(item);
        }
        return item;
    }

    private Item newFloat(float f) {
        Item item = this.get(this.key.set(4, Float.valueOf(f)));
        if (item == null) {
            this.pool.putByte(4).putInt(Float.floatToIntBits(f));
            short s = this.poolIndex;
            this.poolIndex = (short)(s + 1);
            item = new Item(s, this.key);
            this.put(item);
        }
        return item;
    }

    private Item newLong(long l) {
        Item item = this.get(this.key.set(5, l));
        if (item == null) {
            this.pool.putByte(5).putLong(l);
            item = new Item(this.poolIndex, this.key);
            this.put(item);
            this.poolIndex = (short)(this.poolIndex + 2);
        }
        return item;
    }

    private Item newDouble(double d) {
        Item item = this.get(this.key.set(6, d));
        if (item == null) {
            this.pool.putByte(6).putLong(Double.doubleToLongBits(d));
            item = new Item(this.poolIndex, this.key);
            this.put(item);
            this.poolIndex = (short)(this.poolIndex + 2);
        }
        return item;
    }

    private Item newString(String string) {
        Item item = this.get(this.key2.set(8, string, null, null));
        if (item == null) {
            this.pool.putBS(8, this.newUTF8(string));
            short s = this.poolIndex;
            this.poolIndex = (short)(s + 1);
            item = new Item(s, this.key2);
            this.put(item);
        }
        return item;
    }

    public int newNameType(String string, String string2) {
        Item item = this.get(this.key2.set(12, string, string2, null));
        if (item == null) {
            this.put122(12, this.newUTF8(string), this.newUTF8(string2));
            short s = this.poolIndex;
            this.poolIndex = (short)(s + 1);
            item = new Item(s, this.key2);
            this.put(item);
        }
        return item.index;
    }

    private Item get(Item item) {
        return this.items.get(item);
    }

    private void put(Item item) {
        this.items.put(item, item);
    }

    private void put122(int n, int n2, int n3) {
        this.pool.putBS(n, n2).putShort(n3);
    }
}

