/*
 * Decompiled with CFR 0.152.
 */
package org.febit.wit.util.charset;

public class UTF8 {
    public static final int MAX_BYTES_PER_CHAR = 3;

    private UTF8() {
    }

    public static int decode(byte[] byArray, int n, int n2, char[] cArray) {
        int n3 = n + n2;
        int n4 = 0;
        int n5 = n;
        while (n5 < n3) {
            int n6;
            byte by;
            if ((by = byArray[n5++]) >= 0) {
                cArray[n4++] = (char)by;
                continue;
            }
            if (by >> 5 == -2 && n5 < n3) {
                n6 = byArray[n5++];
                if ((by & 0x1E) != 0 && (n6 & 0xC0) == 128) {
                    cArray[n4++] = (char)(by << 6 ^ n6 ^ 0xF80);
                    continue;
                }
                --n5;
            } else if (by >> 4 == -2 && n5 + 1 < n3) {
                n6 = byArray[n5++];
                byte by2 = byArray[n5++];
                if ((by != -32 || (n6 & 0xE0) != 128) && (n6 & 0xC0) == 128 && (by2 & 0xC0) == 128) {
                    cArray[n4++] = (char)(by << 12 ^ n6 << 6 ^ (by2 ^ 0xFFFE1F80));
                    continue;
                }
                n5 -= 2;
            } else if (by >> 3 == -2 && n5 + 2 < n3) {
                if (Character.isSupplementaryCodePoint(n6 = by << 18 ^ byArray[n5++] << 12 ^ byArray[n5++] << 6 ^ (byArray[n5++] ^ 0x381F80))) {
                    cArray[n4++] = (char)((n6 >>> 10) + 55232);
                    cArray[n4++] = (char)((n6 & 0x3FF) + 56320);
                    continue;
                }
                n5 -= 3;
            }
            cArray[n4++] = 65533;
        }
        return n4;
    }

    public static int encode(byte[] byArray, char[] cArray, int n, int n2) {
        int n3 = 0;
        int n4 = n;
        while (n4 < n2) {
            char c;
            if ((c = cArray[n4++]) < '\u0080') {
                byArray[n3++] = (byte)c;
                continue;
            }
            if (c < '\u0800') {
                byArray[n3++] = (byte)(0xC0 | c >> 6);
                byArray[n3++] = (byte)(0x80 | c & 0x3F);
                continue;
            }
            if (c >>> 11 != 27) {
                byArray[n3++] = (byte)(0xE0 | c >> 12);
                byArray[n3++] = (byte)(0x80 | c >> 6 & 0x3F);
                byArray[n3++] = (byte)(0x80 | c & 0x3F);
                continue;
            }
            if (c <= '\udbff' && n4 < n2) {
                char c2;
                if ((c2 = cArray[n4++]) >>> 10 == 55) {
                    int n5 = Character.toCodePoint(c, c2);
                    byArray[n3++] = (byte)(0xF0 | n5 >> 18);
                    byArray[n3++] = (byte)(0x80 | n5 >> 12 & 0x3F);
                    byArray[n3++] = (byte)(0x80 | n5 >> 6 & 0x3F);
                    byArray[n3++] = (byte)(0x80 | n5 & 0x3F);
                    continue;
                }
                --n4;
            }
            byArray[n3++] = 63;
        }
        return n3;
    }
}

