/*
 * Decompiled with CFR 0.152.
 */
package org.febit.wit.util.bean;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Stream;
import org.febit.wit.util.ClassUtil;
import org.febit.wit.util.bean.FieldInfo;

public class FieldInfoResolver {
    private final Class<?> beanType;
    private final Map<String, FieldInfo> fieldInfos;

    private FieldInfoResolver(Class<?> clazz) {
        this.beanType = clazz;
        this.fieldInfos = new HashMap<String, FieldInfo>();
    }

    public static Stream<FieldInfo> resolve(Class<?> clazz) {
        return new FieldInfoResolver(clazz).resolve();
    }

    private Stream<FieldInfo> resolve() {
        for (Field accessibleObject : this.beanType.getFields()) {
            if (ClassUtil.isStatic(accessibleObject)) continue;
            this.registField(accessibleObject);
        }
        for (AccessibleObject accessibleObject : this.beanType.getMethods()) {
            if (ClassUtil.isStatic((Member)((Object)accessibleObject)) || ((Method)accessibleObject).getDeclaringClass() == Object.class) continue;
            int n = ((Method)accessibleObject).getParameterCount();
            String string = ((Method)accessibleObject).getName();
            int n2 = string.length();
            if (n == 0 && ((Method)accessibleObject).getReturnType() != Void.TYPE) {
                if (n2 > 3 && string.startsWith("get")) {
                    this.registGetterMethod(FieldInfoResolver.cutFieldName(string, 3), (Method)accessibleObject);
                    continue;
                }
                if (n2 <= 2 || !string.startsWith("is")) continue;
                this.registGetterMethod(FieldInfoResolver.cutFieldName(string, 2), (Method)accessibleObject);
                continue;
            }
            if (n != 1 || n2 <= 3 || ((Method)accessibleObject).getReturnType() != Void.TYPE || !string.startsWith("set")) continue;
            this.registSetterMethod(FieldInfoResolver.cutFieldName(string, 3), (Method)accessibleObject);
        }
        return this.fieldInfos.values().stream();
    }

    private FieldInfo getOrCreateFieldInfo(String string2) {
        return this.fieldInfos.computeIfAbsent(string2, string -> new FieldInfo(this.beanType, (String)string));
    }

    private void registField(Field field) {
        this.getOrCreateFieldInfo((String)field.getName()).field = field;
    }

    private void registGetterMethod(String string, Method method) {
        this.getOrCreateFieldInfo((String)string).getterMethod = method;
    }

    private void registSetterMethod(String string, Method method) {
        this.getOrCreateFieldInfo((String)string).setterMethod = method;
    }

    static String cutFieldName(String string, int n) {
        char c;
        int n2 = n + 1;
        int n3 = string.length();
        if (n3 > n2 && (c = string.charAt(n2)) >= 'A' && c <= 'Z') {
            return string.substring(n);
        }
        char[] cArray = new char[n3 - n];
        string.getChars(n, n3, cArray, 0);
        char c2 = cArray[0];
        if (c2 >= 'A' && c2 <= 'Z') {
            cArray[0] = (char)(c2 + 32);
        }
        return new String(cArray);
    }
}

