/*
 * Decompiled with CFR 0.152.
 */
package org.febit.wit.util.bean;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.febit.wit.util.ClassUtil;
import org.febit.wit.util.bean.BeanUtil;

public final class FieldInfo
implements Comparable<FieldInfo> {
    public final String name;
    public final Class<?> owner;
    public final int hashOfName;
    Field field;
    Method getterMethod;
    Method setterMethod;

    public FieldInfo(Class<?> clazz, String string) {
        this.owner = clazz;
        this.name = string;
        this.hashOfName = string.hashCode();
    }

    public Method getGetterMethod() {
        return this.getterMethod;
    }

    public Method getSetterMethod() {
        return this.setterMethod;
    }

    public BeanUtil.Getter getGetter() {
        if (this.getterMethod != null) {
            return new BeanUtil.MethodGetter(this.getterMethod);
        }
        if (this.field != null) {
            return new BeanUtil.FieldGetter(this.field);
        }
        return null;
    }

    public BeanUtil.Setter getSetter() {
        if (this.setterMethod != null) {
            return new BeanUtil.MethodSetter(this.setterMethod);
        }
        if (this.isFieldSettable()) {
            return new BeanUtil.FieldSetter(this.field);
        }
        return null;
    }

    public Field getField() {
        return this.field;
    }

    public boolean isFieldSettable() {
        return this.field != null && !ClassUtil.isFinal(this.field);
    }

    @Override
    public int compareTo(FieldInfo fieldInfo) {
        return Integer.compare(this.hashOfName, fieldInfo.hashOfName);
    }

    public int hashCode() {
        return this.hashOfName;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || !(object instanceof FieldInfo)) {
            return false;
        }
        FieldInfo fieldInfo = (FieldInfo)object;
        return this.owner == fieldInfo.owner && this.name.equals(fieldInfo.name);
    }
}

