/*
 * Decompiled with CFR 0.152.
 */
package org.febit.wit.util.bean;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.febit.wit.util.ClassMap;
import org.febit.wit.util.ClassUtil;
import org.febit.wit.util.bean.BeanException;
import org.febit.wit.util.bean.FieldInfoResolver;

public class BeanUtil {
    private static final ClassMap<Map<String, Accessor>> CACHE = new ClassMap();

    private BeanUtil() {
    }

    public static Object get(Object object, String string) throws BeanException {
        Getter getter = BeanUtil.getAccessor(object.getClass(), (String)string).getter;
        if (getter != null) {
            return getter.get(object);
        }
        throw new BeanException("Unable to get getter for {}#{}", object.getClass(), string);
    }

    public static void set(Object object, String string, Object object2) throws BeanException {
        Setter setter = BeanUtil.getAccessor(object.getClass(), (String)string).setter;
        if (setter != null) {
            setter.set(object, object2);
            return;
        }
        throw new BeanException("Unable to get setter for {}#{}", object.getClass(), string);
    }

    private static Accessor getAccessor(Class<?> clazz, String string) throws BeanException {
        Accessor accessor;
        Map<String, Accessor> map = CACHE.unsafeGet(clazz);
        if (map == null) {
            map = CACHE.putIfAbsent(clazz, BeanUtil.resolveAccessors(clazz));
        }
        if ((accessor = map.get(string)) != null) {
            return accessor;
        }
        throw new BeanException("Unable to get field: {}#{}", clazz, string);
    }

    private static Map<String, Accessor> resolveAccessors(Class<?> clazz) {
        HashMap<String, Accessor> hashMap = new HashMap<String, Accessor>();
        FieldInfoResolver.resolve(clazz).forEach(fieldInfo -> hashMap.put(fieldInfo.name, new Accessor(fieldInfo.getGetter(), fieldInfo.getSetter())));
        return hashMap;
    }

    static final class FieldSetter
    implements Setter {
        private final Field field;

        FieldSetter(Field field) {
            ClassUtil.setAccessible(field);
            this.field = field;
        }

        @Override
        public void set(Object object, Object object2) throws BeanException {
            try {
                this.field.set(object, object2);
            }
            catch (IllegalAccessException | IllegalArgumentException exception) {
                throw new BeanException(exception.toString(), exception);
            }
        }

        @Override
        public Class<?> getType() {
            return this.field.getType();
        }
    }

    static final class FieldGetter
    implements Getter {
        private final Field field;

        FieldGetter(Field field) {
            ClassUtil.setAccessible(field);
            this.field = field;
        }

        @Override
        public Object get(Object object) throws BeanException {
            try {
                return this.field.get(object);
            }
            catch (IllegalAccessException | IllegalArgumentException exception) {
                throw new BeanException(exception.toString(), exception);
            }
        }
    }

    static final class MethodSetter
    implements Setter {
        private final Method method;
        private final Class<?> fieldType;

        MethodSetter(Method method) {
            ClassUtil.setAccessible(method);
            this.method = method;
            this.fieldType = method.getParameterTypes()[0];
        }

        @Override
        public Class<?> getType() {
            return this.fieldType;
        }

        @Override
        public void set(Object object, Object object2) throws BeanException {
            try {
                this.method.invoke(object, object2);
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException exception) {
                throw new BeanException(exception.toString(), exception);
            }
        }
    }

    static final class MethodGetter
    implements Getter {
        private final Method method;

        MethodGetter(Method method) {
            ClassUtil.setAccessible(method);
            this.method = method;
        }

        @Override
        public Object get(Object object) throws BeanException {
            try {
                return this.method.invoke(object, (Object[])null);
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException exception) {
                throw new BeanException(exception.toString(), exception);
            }
        }
    }

    public static interface Setter {
        public Class<?> getType();

        public void set(Object var1, Object var2);
    }

    public static interface Getter {
        public Object get(Object var1);
    }

    private static final class Accessor {
        final Getter getter;
        final Setter setter;

        Accessor(Getter getter, Setter setter) {
            this.getter = getter;
            this.setter = setter;
        }
    }
}

