/*
 * Decompiled with CFR 0.152.
 */
package org.febit.wit.util;

import java.util.ArrayList;
import java.util.List;
import org.febit.wit.util.ArrayUtil;

public class StringUtil {
    private StringUtil() {
    }

    public static String join(List<?> list, char c) {
        if (list == null || list.isEmpty()) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (Object obj : list) {
            stringBuilder.append(obj).append(c);
        }
        return stringBuilder.substring(0, stringBuilder.length() - 1);
    }

    private static boolean isArrayValueEnd(char c) {
        return c == ',' || c == '\n' || c == '\r';
    }

    private static boolean isArrayValueEndOrEmpty(char c) {
        switch (c) {
            case '\t': 
            case '\n': 
            case '\r': 
            case ' ': 
            case ',': {
                return true;
            }
        }
        return false;
    }

    public static String[] toArray(String string) {
        if (string == null || string.isEmpty()) {
            return ArrayUtil.emptyStrings();
        }
        char[] cArray = string.toCharArray();
        int n = cArray.length;
        ArrayList<String> arrayList = new ArrayList<String>(n > 1024 ? 64 : 16);
        int n2 = 0;
        while (n2 < n) {
            while (n2 < n && StringUtil.isArrayValueEndOrEmpty(cArray[n2])) {
                ++n2;
            }
            if (n2 == n) break;
            int n3 = n2;
            while (n2 < n && !StringUtil.isArrayValueEnd(cArray[n2])) {
                ++n2;
            }
            int n4 = n2;
            while (StringUtil.isArrayValueEndOrEmpty(cArray[n4 - 1])) {
                --n4;
            }
            arrayList.add(new String(cArray, n3, n4 - n3));
        }
        return arrayList.isEmpty() ? ArrayUtil.emptyStrings() : arrayList.toArray(new String[arrayList.size()]);
    }

    public static String format(String string, Object ... objectArray) {
        if (string == null) {
            return null;
        }
        if (string.indexOf(123) < 0) {
            return string;
        }
        StringBuilder stringBuilder = new StringBuilder(string.length());
        int n = string.length();
        int n2 = objectArray != null ? objectArray.length : 0;
        int n3 = 0;
        int n4 = 0;
        while (n3 < n) {
            int n5;
            int n6;
            int n7;
            int n8 = string.indexOf(123, n3);
            if (n8 == -1) {
                stringBuilder.append(n3 == 0 ? string : string.substring(n3));
                break;
            }
            for (n7 = n8 - 1; n7 >= 0 && string.charAt(n7) == '\\'; --n7) {
            }
            int n9 = n8 - 1 - n7;
            stringBuilder.append(string.substring(n3, n9 > 0 ? n8 - (n9 + 1 >> 1) : n8));
            if ((n9 & 1) == 1) {
                stringBuilder.append('{');
                n3 = n8 + 1;
                continue;
            }
            if ((n6 = string.indexOf(125, ++n8)) == -1) {
                throw new IllegalArgumentException("Invalid message, unclosed macro at: " + (n8 - 1));
            }
            int n10 = n5 = n8 == n6 ? n4++ : Integer.parseInt(string.substring(n8, n6));
            if (n5 < n2 && n5 >= 0 && objectArray[n5] != null) {
                stringBuilder.append(objectArray[n5].toString());
            }
            n3 = n6 + 1;
        }
        return stringBuilder.toString();
    }
}

