/*
 * Decompiled with CFR 0.152.
 */
package org.febit.wit.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.febit.wit.InternalContext;
import org.febit.wit.core.LoopInfo;
import org.febit.wit.core.ast.Expression;
import org.febit.wit.core.ast.Loopable;
import org.febit.wit.core.ast.Statement;
import org.febit.wit.core.ast.expressions.DirectValue;
import org.febit.wit.core.ast.statements.StatementGroup;
import org.febit.wit.exceptions.ParseException;
import org.febit.wit.exceptions.ScriptRuntimeException;
import org.febit.wit.util.ALU;

public class StatementUtil {
    private static final Statement[] EMPTY_STATEMENTS = new Statement[0];
    private static final Expression[] EMPTY_EXPRESSIONS = new Expression[0];

    private StatementUtil() {
    }

    public static boolean isImmutableDirectValue(Expression expression) {
        return expression instanceof DirectValue && ALU.isKnownBaseImmutable(((DirectValue)expression).value);
    }

    public static Object calcConst(Expression expression) {
        return StatementUtil.optimize(expression).getConstValue();
    }

    public static Object[] calcConstArray(Expression[] expressionArray) {
        int n = expressionArray.length;
        Object[] objectArray = new Object[n];
        for (int i = 0; i < n; ++i) {
            objectArray[i] = StatementUtil.calcConst(expressionArray[i]);
        }
        return objectArray;
    }

    public static Object[] execute(Expression[] expressionArray, InternalContext internalContext) {
        int n = expressionArray.length;
        Object[] objectArray = new Object[n];
        for (int i = 0; i < n; ++i) {
            objectArray[i] = expressionArray[i].execute(internalContext);
        }
        return objectArray;
    }

    public static void execute(Statement[] statementArray, InternalContext internalContext) {
        int n = 0;
        int n2 = statementArray.length;
        while (n < n2) {
            statementArray[n++].execute(internalContext);
        }
    }

    public static void executeWithLoopCheck(Statement[] statementArray, InternalContext internalContext) {
        int n = 0;
        int n2 = statementArray.length;
        while (n < n2 && internalContext.noLoop()) {
            statementArray[n++].execute(internalContext);
        }
    }

    public static Expression optimize(Expression expression) {
        if (expression == null) {
            return null;
        }
        return expression.optimize();
    }

    public static void optimize(Expression[] expressionArray) {
        for (int i = 0; i < expressionArray.length; ++i) {
            expressionArray[i] = StatementUtil.optimize(expressionArray[i]);
        }
    }

    public static Statement optimize(Statement statement) {
        if (statement == null) {
            return null;
        }
        try {
            return statement.optimize();
        }
        catch (Exception exception) {
            throw new ParseException("Exception occur when do optimization", exception, statement);
        }
    }

    public static List<LoopInfo> asList(LoopInfo ... loopInfoArray) {
        if (loopInfoArray == null || loopInfoArray.length == 0) {
            return Collections.emptyList();
        }
        return Arrays.asList(loopInfoArray);
    }

    public static List<LoopInfo> collectPossibleLoops(Statement statement) {
        if (statement instanceof Loopable) {
            return ((Loopable)((Object)statement)).collectPossibleLoops();
        }
        return Collections.emptyList();
    }

    public static List<LoopInfo> collectPossibleLoops(Statement ... statementArray) {
        if (statementArray == null || statementArray.length == 0) {
            return Collections.emptyList();
        }
        ArrayList<LoopInfo> arrayList = new ArrayList<LoopInfo>();
        for (Statement statement : statementArray) {
            arrayList.addAll(StatementUtil.collectPossibleLoops(statement));
        }
        return arrayList;
    }

    public static LoopInfo[] collectPossibleLoopsForWhile(Statement statement, Statement statement2, int n) {
        List<LoopInfo> list = StatementUtil.collectPossibleLoops(statement).stream().filter(loopInfo -> !loopInfo.matchLabel(n) || loopInfo.type != 1 && loopInfo.type != 2).collect(Collectors.toList());
        list.addAll(StatementUtil.collectPossibleLoops(statement2));
        return list.isEmpty() ? null : list.toArray(new LoopInfo[list.size()]);
    }

    public static ScriptRuntimeException castToScriptRuntimeException(Exception exception, Statement statement) {
        if (exception instanceof ScriptRuntimeException) {
            ScriptRuntimeException scriptRuntimeException = (ScriptRuntimeException)exception;
            scriptRuntimeException.addStatement(statement);
            return scriptRuntimeException;
        }
        return new ScriptRuntimeException(exception.toString(), exception, statement);
    }

    public static Expression[] emptyExpressions() {
        return EMPTY_EXPRESSIONS;
    }

    public static Expression[] toExpressionArray(List<Expression> list) {
        if (list == null || list.isEmpty()) {
            return EMPTY_EXPRESSIONS;
        }
        Expression[] expressionArray = list.toArray(new Expression[list.size()]);
        for (int i = 0; i < expressionArray.length; ++i) {
            expressionArray[i] = StatementUtil.optimize(expressionArray[i]);
        }
        return expressionArray;
    }

    public static Statement[] toStatementArray(List<Statement> list) {
        if (list == null || list.isEmpty()) {
            return EMPTY_STATEMENTS;
        }
        ArrayList<Statement> arrayList = new ArrayList<Statement>(list.size());
        for (Statement statement : list) {
            if (statement instanceof StatementGroup) {
                arrayList.addAll(Arrays.asList(((StatementGroup)statement).getList()));
                continue;
            }
            if ((statement = StatementUtil.optimize(statement)) == null) continue;
            arrayList.add(statement);
        }
        return list.isEmpty() ? EMPTY_STATEMENTS : arrayList.toArray(new Statement[arrayList.size()]);
    }
}

