/*
 * Decompiled with CFR 0.152.
 */
package org.febit.wit.util;

import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.febit.wit.exceptions.IllegalConfigException;
import org.febit.wit.util.ClassUtil;
import org.febit.wit.util.Props;
import org.febit.wit.util.StringUtil;

public class PropsUtil {
    public static final ClasspathInputResolver CLASSPATH_INPUT_RESOLVER = new ClasspathInputResolver();

    private PropsUtil() {
    }

    public static Props loadFromClasspath(Props props, String ... stringArray) {
        return PropsUtil.load(props, CLASSPATH_INPUT_RESOLVER, stringArray);
    }

    public static Props load(Props props, InputResolver inputResolver, String ... stringArray) {
        if (stringArray != null) {
            new PropsLoader(props).load(inputResolver, stringArray);
        }
        return props;
    }

    public static class ClasspathInputResolver
    implements InputResolver {
        ClasspathInputResolver() {
        }

        @Override
        public InputStream openInputStream(String string) {
            return ClassUtil.getDefaultClassLoader().getResourceAsStream(this.fixModuleName(string));
        }

        @Override
        public String getViewPath(String string) {
            return "classpath:".concat(this.fixModuleName(string));
        }

        @Override
        public String fixModuleName(String string) {
            return string.charAt(0) == '/' ? string.substring(1) : string;
        }
    }

    public static interface InputResolver {
        public InputStream openInputStream(String var1);

        public String getViewPath(String var1);

        public String fixModuleName(String var1);
    }

    private static class PropsLoader {
        private final Props props;
        private final char[] buffer;
        private final CharArrayWriter charsBuffer;
        private Set<String> loadedModules;
        private Map<String, Props> modulePropsCache;

        PropsLoader(Props props) {
            this.props = props;
            this.buffer = new char[3072];
            this.charsBuffer = new CharArrayWriter();
        }

        private void mergeProps(Props props, String string) {
            if (this.props.containsModule(string)) {
                return;
            }
            this.props.merge(props);
            this.props.addModule(string);
        }

        private void resolveModules(Props props) {
            this.resolveModules(props.remove("@modules"));
        }

        private void resolveModules(String string) {
            if (string == null) {
                return;
            }
            if (this.loadedModules == null) {
                this.loadedModules = new HashSet<String>();
            }
            if (this.modulePropsCache == null) {
                this.modulePropsCache = new HashMap<String, Props>();
            }
            for (String string2 : StringUtil.toArray(string)) {
                if (this.loadedModules.contains(string2)) continue;
                Props props = this.modulePropsCache.get(string2);
                if (props == null) {
                    props = this.loadProps(CLASSPATH_INPUT_RESOLVER, string2);
                    this.modulePropsCache.put(string2, props);
                    this.resolveModules(props);
                    if (this.loadedModules.contains(string2)) continue;
                }
                this.loadedModules.add(string2);
                this.mergeProps(props, CLASSPATH_INPUT_RESOLVER.getViewPath(string2));
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private Props loadProps(InputResolver inputResolver, String string) {
            CharArrayWriter charArrayWriter = this.charsBuffer;
            char[] cArray = this.buffer;
            InputStream inputStream = inputResolver.openInputStream(string);
            if (inputStream == null) {
                throw new IllegalConfigException("Not found props: ".concat(inputResolver.getViewPath(string)));
            }
            try (InputStreamReader inputStreamReader = new InputStreamReader(inputStream, "UTF-8");){
                int n;
                charArrayWriter.reset();
                while ((n = inputStreamReader.read(cArray)) >= 0) {
                    charArrayWriter.write(cArray, 0, n);
                }
                Props props = new Props();
                props.load(charArrayWriter.toCharArray());
                charArrayWriter.reset();
                Props props2 = props;
                return props2;
            }
            catch (IOException iOException) {
                throw new IllegalConfigException("Not found props: ".concat(inputResolver.getViewPath(string)), iOException);
            }
        }

        void load(InputResolver inputResolver, String ... stringArray) {
            if (inputResolver instanceof ClasspathInputResolver) {
                for (String string : stringArray) {
                    this.resolveModules(string);
                }
            } else {
                for (String string : stringArray) {
                    for (String string2 : StringUtil.toArray(string)) {
                        Props props = this.loadProps(inputResolver, string2);
                        this.resolveModules(props);
                        this.mergeProps(props, inputResolver.getViewPath(string2));
                    }
                }
            }
        }
    }
}

