/*
 * Decompiled with CFR 0.152.
 */
package org.febit.wit.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import org.febit.wit.util.StringUtil;

public final class Props {
    private static final int STATE_TEXT = 1;
    private static final int STATE_ESCAPE = 2;
    private static final int STATE_ESCAPE_NEWLINE = 3;
    private static final int STATE_COMMENT = 4;
    private static final int STATE_VALUE = 5;
    private final Map<String, Entry> data = new HashMap<String, Entry>();
    private List<String> modules;

    public Props load(String string) {
        if (string != null) {
            this.parse(string.toCharArray());
        }
        return this;
    }

    public Props load(char[] cArray) {
        if (cArray != null) {
            this.parse(cArray);
        }
        return this;
    }

    public void addModule(String string) {
        if (string == null) {
            return;
        }
        this.initModules();
        this.modules.add(string);
    }

    private void initModules() {
        if (this.modules == null) {
            this.modules = new ArrayList<String>();
        }
    }

    public boolean containsModule(String string) {
        if (this.modules == null) {
            return false;
        }
        return this.modules.contains(string);
    }

    public List<String> getModules() {
        if (this.modules == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this.modules);
    }

    public String getModulesString() {
        if (this.modules == null) {
            return "";
        }
        return StringUtil.join(this.modules, ',');
    }

    public void addModules(Collection<String> collection) {
        if (collection == null) {
            return;
        }
        this.initModules();
        this.modules.addAll(collection);
    }

    public void merge(Props props) {
        props.data.forEach((? super K string, ? super V entry) -> this.put((String)string, entry.value, entry.append));
        this.addModules(props.modules);
    }

    public String remove(String string) {
        return this.resolveValue(this.data.remove(string));
    }

    public String get(String string) {
        return this.resolveValue(this.data.get(string));
    }

    public void set(String string, String string2) {
        this.put(string, string2, false);
    }

    public void append(String string, String string2) {
        this.put(string, string2, true);
    }

    public void forEach(BiConsumer<? super String, ? super String> biConsumer) {
        Objects.requireNonNull(biConsumer);
        this.data.forEach((? super K string, ? super V entry) -> biConsumer.accept((String)string, this.resolveValue((Entry)entry)));
    }

    public void extractTo(Map<? super String, ? super String> map) {
        this.forEach(map::put);
    }

    private void put(String string, String string2, boolean bl) {
        Entry entry;
        if (string2 == null) {
            if (!bl) {
                this.data.remove(string);
            }
            return;
        }
        if (bl && (entry = this.data.get(string)) != null) {
            string2 = entry.value + ',' + string2;
            bl = entry.append;
        }
        this.data.put(string, new Entry(string, string2, bl));
    }

    private void put(String string, String string2, String string3, boolean bl) {
        if (string2 == null) {
            return;
        }
        if (string == null) {
            this.put(string2, string3, bl);
            return;
        }
        this.put(string2.isEmpty() ? string : string + '.' + string2, string3, bl);
    }

    protected Entry resolveEntry(String string, String string2) {
        if (string == null || string.isEmpty()) {
            return this.data.get(string2);
        }
        Entry entry = this.data.get(string + '.' + string2);
        if (entry != null) {
            return entry;
        }
        return this.resolveEntry(Props.cutSpace(string), string2);
    }

    private String resolveValue(Entry entry) {
        if (entry == null) {
            return null;
        }
        return this.resolveValue(entry.space(), entry.value, 0);
    }

    private String resolveValue(String string, String string2, int n) {
        if (n > 100) {
            throw new IllegalArgumentException("Invalid string template, macros nested times > 100");
        }
        int n2 = string2.indexOf("${");
        if (n2 < 0) {
            return string2;
        }
        boolean bl = false;
        int n3 = 0;
        for (int i = n2 - 1; i >= 0 && string2.charAt(i) == '\\'; --i) {
            boolean bl2 = bl = !bl;
            if (!bl) continue;
            ++n3;
        }
        String string3 = string2.substring(0, n2 - n3);
        String string4 = this.resolveValue(string, string2.substring(n2 + 2), ++n);
        if (bl) {
            return string3 + "${" + string4;
        }
        int n4 = string4.indexOf(125);
        if (n4 < 0) {
            throw new IllegalArgumentException("Invalid string template, unclosed macro ");
        }
        String string5 = string4.substring(n4 + 1);
        String string6 = string4.substring(0, n4);
        Entry entry = this.resolveEntry(string, string6);
        if (entry != null && entry.value != null) {
            return string3 + this.resolveValue(entry.space(), entry.value, ++n) + string5;
        }
        return string3 + string5;
    }

    private void parse(char[] cArray) {
        StringBuilder stringBuilder = new StringBuilder();
        int n = cArray.length;
        int n2 = 1;
        int n3 = -1;
        boolean bl = false;
        String string = null;
        String string2 = null;
        boolean bl2 = false;
        int n4 = 0;
        block23: while (n4 < n) {
            char c = cArray[n4++];
            if (n2 == 4) {
                if (c != '\n') continue;
                n2 = 1;
                continue;
            }
            if (n2 == 2) {
                n2 = n3;
                switch (c) {
                    case '\n': 
                    case '\r': {
                        n2 = 3;
                        continue block23;
                    }
                    case 'u': {
                        stringBuilder.append(Props.readUtf(cArray, n4));
                        n4 += 4;
                        continue block23;
                    }
                    case 't': {
                        stringBuilder.append('\t');
                        continue block23;
                    }
                    case 'n': {
                        stringBuilder.append('\n');
                        continue block23;
                    }
                    case 'r': {
                        stringBuilder.append('\r');
                        continue block23;
                    }
                    case 'f': {
                        stringBuilder.append('\f');
                        continue block23;
                    }
                }
                stringBuilder.append(c);
                continue;
            }
            if (n2 == 1) {
                switch (c) {
                    case '\\': {
                        n3 = n2;
                        n2 = 2;
                        continue block23;
                    }
                    case '[': {
                        stringBuilder.setLength(0);
                        bl = true;
                        continue block23;
                    }
                    case ']': {
                        if (bl) {
                            string = this.formatSection(stringBuilder.toString());
                            stringBuilder.setLength(0);
                            bl = false;
                            continue block23;
                        }
                        stringBuilder.append(c);
                        continue block23;
                    }
                    case '#': 
                    case ';': {
                        n2 = 4;
                        continue block23;
                    }
                    case '+': {
                        if (n4 == n || cArray[n4] != '=') {
                            stringBuilder.append(c);
                            continue block23;
                        }
                        bl2 = true;
                        continue block23;
                    }
                    case '=': {
                        if (string2 == null) {
                            string2 = stringBuilder.toString().trim();
                            stringBuilder.setLength(0);
                        } else {
                            stringBuilder.append(c);
                        }
                        n2 = 5;
                        continue block23;
                    }
                    case '\n': 
                    case '\r': {
                        this.put(string, string2, stringBuilder.toString().trim(), bl2);
                        stringBuilder.setLength(0);
                        string2 = null;
                        bl2 = false;
                        continue block23;
                    }
                    case '\t': 
                    case ' ': {
                        if (stringBuilder.length() <= 0) continue block23;
                        stringBuilder.append(c);
                        continue block23;
                    }
                }
                stringBuilder.append(c);
                continue;
            }
            switch (c) {
                case '\\': {
                    n3 = n2;
                    n2 = 2;
                    break;
                }
                case '\n': 
                case '\r': {
                    if (n2 == 3 && c == '\n') continue block23;
                    this.put(string, string2, stringBuilder.toString().trim(), bl2);
                    stringBuilder.setLength(0);
                    string2 = null;
                    bl2 = false;
                    n2 = 1;
                    break;
                }
                case '\t': 
                case ' ': {
                    if (n2 == 3) break;
                }
                default: {
                    stringBuilder.append(c);
                    n2 = 5;
                    if (!Props.isMultiLineStartFlag(stringBuilder)) continue block23;
                    int n5 = Props.findMultiLineEndFlagPos(cArray, n4);
                    this.put(string, string2, new String(cArray, n4, n5 - n4), bl2);
                    stringBuilder.setLength(0);
                    string2 = null;
                    bl2 = false;
                    n2 = 1;
                    n4 = n5 + 3;
                }
            }
        }
        if (string2 != null) {
            this.put(string, string2, stringBuilder.toString().trim(), bl2);
        }
    }

    private String formatSection(String string) {
        String string2 = string.trim();
        if (string2.isEmpty()) {
            return null;
        }
        int n = string2.indexOf(58);
        if (n == 0) {
            throw new IllegalArgumentException("Invalid section, should not start with ':' : " + string2);
        }
        if (n < 0) {
            return string2;
        }
        String string3 = string2.substring(n + 1).trim();
        string2 = string2.substring(0, n).trim();
        if (!string3.isEmpty()) {
            this.put(string2 + ".@class", string3, false);
        }
        return string2;
    }

    private static char readUtf(char[] cArray, int n) {
        int n2 = n + 4;
        if (n2 >= cArray.length) {
            throw new IllegalArgumentException("No more chars for UTF");
        }
        int n3 = 0;
        for (int i = n; i < n2; ++i) {
            char c = cArray[i];
            if (c >= '0' && c <= '9') {
                n3 = (n3 << 4) + c - 48;
                continue;
            }
            if (c >= 'a' && c <= 'f') {
                n3 = (n3 << 4) + 10 + c - 97;
                continue;
            }
            if (c >= 'A' && c <= 'F') {
                n3 = (n3 << 4) + 10 + c - 65;
                continue;
            }
            throw new IllegalArgumentException("Malformed \\uXXXX encoding.");
        }
        return (char)n3;
    }

    private static int findMultiLineEndFlagPos(char[] cArray, int n) {
        int n2;
        int n3 = cArray.length;
        int n4 = 0;
        for (n2 = n; n2 < n3; ++n2) {
            if (cArray[n2] == '\'') {
                if (n4 == 2) {
                    n2 -= 2;
                    break;
                }
                ++n4;
                continue;
            }
            n4 = 0;
        }
        return n2;
    }

    private static boolean isMultiLineStartFlag(StringBuilder stringBuilder) {
        return stringBuilder.length() == 3 && stringBuilder.charAt(0) == '\'' && stringBuilder.charAt(1) == '\'' && stringBuilder.charAt(2) == '\'';
    }

    private static String cutSpace(String string) {
        int n = string.lastIndexOf(46);
        return n < 0 ? null : string.substring(0, n);
    }

    private static class Entry {
        final String key;
        final String value;
        final boolean append;

        Entry(String string, String string2, boolean bl) {
            this.key = string;
            this.value = string2;
            this.append = bl;
        }

        String space() {
            return Props.cutSpace(this.key);
        }
    }
}

