/*
 * Decompiled with CFR 0.152.
 */
package org.febit.wit.util;

import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import org.febit.wit.Init;
import org.febit.wit.exceptions.UncheckedException;
import org.febit.wit.loggers.Logger;
import org.febit.wit.util.ArrayUtil;
import org.febit.wit.util.ClassUtil;
import org.febit.wit.util.InternedEncoding;
import org.febit.wit.util.Props;
import org.febit.wit.util.StringUtil;

public class Petite {
    private final Map<Class, Object> components = new HashMap<Class, Object>();
    private final Map<String, Object> beans = new HashMap<String, Object>();
    private final Map<String, Object> datas = new HashMap<String, Object>();
    private final Map<String, Entry> entrys = new HashMap<String, Entry>();
    private Logger logger;

    public <T> T get(Class<T> clazz) {
        Object object = this.components.get(clazz);
        if (object != null) {
            return (T)object;
        }
        return (T)this.get(clazz.getName());
    }

    public Object get(String string) {
        Object object = this.beans.get(string);
        if (object != null) {
            return object;
        }
        return this.resolveBeanIfAbsent(string);
    }

    private synchronized Object resolveBeanIfAbsent(String string) {
        Object object = this.beans.get(string);
        if (object != null) {
            return object;
        }
        object = this.newInstance(string);
        this.inject(string, object);
        this.beans.put(string, object);
        return object;
    }

    public void config(Props props, Map<String, Object> map) {
        if (props == null) {
            props = new Props();
        }
        HashMap<String, Object> hashMap = null;
        if (map != null) {
            map.remove(null);
            hashMap = new HashMap<String, Object>();
            for (Map.Entry<String, Object> entry : map.entrySet()) {
                String string = entry.getKey().trim();
                if (string.isEmpty()) continue;
                Object object = entry.getValue();
                if (!(object instanceof String)) {
                    hashMap.put(string, object);
                    continue;
                }
                int n = string.length();
                if (string.charAt(n - 1) == '+') {
                    props.append(string.substring(0, n - 1).trim(), (String)object);
                    continue;
                }
                props.set(string, (String)object);
            }
        }
        props.forEach(this::setProp);
        if (hashMap != null) {
            hashMap.forEach(this::setProp);
        }
    }

    public Object getConfig(String string) {
        return this.datas.get(string);
    }

    private void setProp(String string, Object object) {
        this.datas.put(string, object);
        int n = string.lastIndexOf(46);
        int n2 = n + 1;
        if (n > 0 && n2 < string.length() && string.charAt(n2) != '@') {
            String string2 = string.substring(0, n);
            this.entrys.put(string2, new Entry(string.substring(n2), object, this.entrys.get(string2)));
        }
    }

    public void addComponent(Object object) {
        for (Class<?> clazz = object.getClass(); clazz != null && clazz != Object.class; clazz = clazz.getSuperclass()) {
            this.components.put(clazz, object);
            for (Class<?> clazz2 : clazz.getInterfaces()) {
                this.components.put(clazz2, object);
            }
        }
    }

    public void initComponents() {
        int n;
        this.addComponent(this);
        String[] stringArray = StringUtil.toArray((String)this.datas.get("@global"));
        int n2 = stringArray.length;
        Object[] objectArray = new Object[n2];
        for (n = 0; n < n2; ++n) {
            Object object;
            String string = stringArray[n];
            objectArray[n] = object = this.newInstance(string);
            this.beans.put(string, object);
            this.addComponent(object);
        }
        for (n = 0; n < n2; ++n) {
            this.inject(stringArray[n], objectArray[n]);
        }
        this.logger = this.get(Logger.class);
    }

    private Object newInstance(String string) {
        String string2;
        do {
            string2 = string;
        } while ((string = (String)this.datas.get(string + ".@class")) != null);
        return ClassUtil.newInstance(string2);
    }

    public void inject(String string, Object object) {
        LinkedList<String> linkedList = new LinkedList<String>();
        do {
            linkedList.addFirst(string);
        } while ((string = (String)this.datas.get(string + ".@class")) != null);
        Map<String, Field> map = ClassUtil.getSettableMemberFields(object.getClass());
        for (Field object2 : map.values()) {
            Object object3 = this.components.get(object2.getType());
            if (object3 == null) continue;
            try {
                object2.set(object, object3);
            }
            catch (IllegalAccessException | IllegalArgumentException exception) {
                throw new UncheckedException(exception);
            }
        }
        HashSet hashSet = new HashSet();
        for (String string2 : linkedList) {
            this.inject(string2, object, hashSet, map);
        }
        this.invokeInitMethods(object);
    }

    private void invokeInitMethods(Object object) {
        for (Method method : object.getClass().getMethods()) {
            Object[] objectArray;
            if (method.getAnnotation(Init.class) == null) continue;
            Class<?>[] classArray = method.getParameterTypes();
            if (classArray.length == 0) {
                objectArray = ArrayUtil.emptyObjects();
            } else {
                objectArray = new Object[classArray.length];
                for (int i = 0; i < classArray.length; ++i) {
                    objectArray[i] = this.components.get(classArray[i]);
                }
            }
            try {
                ClassUtil.setAccessible(method);
                method.invoke(object, objectArray);
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException exception) {
                throw new UncheckedException(exception);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private void inject(String string, Object object, Set<String> set, Map<String, Field> map) {
        void var5_7;
        if (set.contains(string)) {
            return;
        }
        set.add(string);
        for (String string2 : StringUtil.toArray((String)this.datas.get(string.concat(".@extends")))) {
            this.inject(string2, object, set, map);
        }
        Entry entry = this.entrys.get(string);
        while (var5_7 != null) {
            Field field = map.get(var5_7.name);
            if (field == null) {
                if (this.logger != null) {
                    this.logger.warn("Not found field {}#{} ", object.getClass(), var5_7.name);
                }
            } else {
                Object object2 = var5_7.value;
                if (object2 instanceof String) {
                    object2 = this.convert((String)object2, field.getType());
                }
                try {
                    field.set(object, object2);
                }
                catch (IllegalAccessException | IllegalArgumentException exception) {
                    throw new UncheckedException(exception);
                }
            }
            Entry entry2 = var5_7.next;
        }
    }

    private Object convert(String string, Class<?> clazz) {
        if (clazz == String.class) {
            return string;
        }
        if (clazz == Integer.TYPE) {
            if (string == null || string.isEmpty()) {
                return 0;
            }
            return Integer.parseInt(string);
        }
        if (clazz == Boolean.TYPE) {
            return Boolean.valueOf(string);
        }
        if (string == null) {
            return null;
        }
        if (clazz.isArray()) {
            String[] stringArray = StringUtil.toArray(string);
            if (clazz == String[].class) {
                return stringArray;
            }
            Class<?> clazz2 = clazz.getComponentType();
            int n = stringArray.length;
            Object object = Array.newInstance(clazz2, n);
            for (int i = 0; i < n; ++i) {
                Array.set(object, i, this.convert(stringArray[i], clazz2));
            }
            return object;
        }
        if (clazz == Boolean.class) {
            return Boolean.valueOf(string);
        }
        if (string.isEmpty()) {
            return null;
        }
        if (clazz == Class.class) {
            return ClassUtil.getClass(string);
        }
        if (clazz == Integer.class) {
            return Integer.parseInt(string);
        }
        if (clazz == InternedEncoding.class) {
            return InternedEncoding.intern(string);
        }
        return this.get(string);
    }

    private static final class Entry {
        final String name;
        final Object value;
        final Entry next;

        Entry(String string, Object object, Entry entry) {
            this.name = string;
            this.value = object;
            this.next = entry;
        }
    }
}

