/*
 * Decompiled with CFR 0.152.
 */
package org.febit.wit.util;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.febit.wit.InternalContext;
import org.febit.wit.core.NativeFactory;
import org.febit.wit.exceptions.AmbiguousMethodException;
import org.febit.wit.exceptions.ScriptRuntimeException;
import org.febit.wit.exceptions.UncheckedException;
import org.febit.wit.global.GlobalManager;
import org.febit.wit.util.ArrayUtil;
import org.febit.wit.util.ClassUtil;

public class JavaNativeUtil {
    private static final int COST_NEVER = -1;
    private static final int COST_EXACT = 0;
    private static final int COST_ASSIGNABLE = 1;
    private static final int COST_OBJECT = 100;
    private static final int COST_PRIMITIVE = 10;
    private static final int COST_NULL = 1000000;
    private static final Class<?>[] EMPTY_CLASSES = new Class[0];

    private JavaNativeUtil() {
    }

    public static int addStaticMethods(GlobalManager globalManager, NativeFactory nativeFactory, Class<?> clazz) {
        return JavaNativeUtil.addStaticMethods(globalManager, nativeFactory, clazz, false);
    }

    public static int addStaticMethods(GlobalManager globalManager, NativeFactory nativeFactory, Class<?> clazz, boolean bl) {
        Map<String, List<Method>> map = Arrays.stream(clazz.getMethods()).filter(ClassUtil::isStatic).filter(method -> !bl || !globalManager.hasConst(method.getName())).collect(Collectors.groupingBy(Method::getName));
        map.forEach((string, list) -> globalManager.setConst((String)string, nativeFactory.createNativeMethodDeclare((List<Method>)list)));
        return map.size();
    }

    public static int addConstFields(GlobalManager globalManager, NativeFactory nativeFactory, Class<?> clazz) {
        return JavaNativeUtil.addConstFields(globalManager, nativeFactory, clazz, false);
    }

    public static int addConstFields(GlobalManager globalManager, NativeFactory nativeFactory, Class<?> clazz, boolean bl) {
        int n = 0;
        for (Field field : clazz.getFields()) {
            if (!ClassUtil.isStatic(field) || !ClassUtil.isFinal(field)) continue;
            String string = field.getName();
            if (bl && globalManager.hasConst(string)) continue;
            ClassUtil.setAccessible(field);
            try {
                globalManager.setConst(string, field.get(null));
            }
            catch (IllegalAccessException | IllegalArgumentException exception) {
                throw new UncheckedException(exception);
            }
        }
        return n;
    }

    public static Class<?>[] getArgTypes(Object[] objectArray) {
        if (objectArray == null || objectArray.length == 0) {
            return EMPTY_CLASSES;
        }
        Class[] classArray = new Class[objectArray.length];
        for (int i = 0; i < classArray.length; ++i) {
            classArray[i] = objectArray[i] != null ? objectArray[i].getClass() : null;
        }
        return classArray;
    }

    public static Method getMatchMethod(Method[] methodArray, Object[] objectArray) {
        return JavaNativeUtil.getMatchMethod(methodArray, JavaNativeUtil.getArgTypes(objectArray));
    }

    public static Method getMatchMethod(Method[] methodArray, Object[] objectArray, boolean bl) {
        return JavaNativeUtil.getMatchMethod(methodArray, JavaNativeUtil.getArgTypes(objectArray), bl);
    }

    public static Method getMatchMethod(Method[] methodArray, Class<?>[] classArray) {
        return JavaNativeUtil.getMatchMethod(methodArray, classArray, false);
    }

    public static Method getMatchMethod(Method[] methodArray, Class<?>[] classArray, boolean bl) {
        if (methodArray == null || methodArray.length == 0) {
            return null;
        }
        Method[] methodArray2 = new Method[methodArray.length];
        int n = 0;
        int n2 = Integer.MAX_VALUE;
        Class<?>[] classArray2 = null;
        for (Method method : methodArray) {
            int n3;
            if (bl && !ClassUtil.isStatic(method)) {
                if (classArray.length == 0 || classArray[0] == null || !method.getDeclaringClass().isAssignableFrom(classArray[0])) continue;
                if (classArray2 == null) {
                    classArray2 = Arrays.copyOfRange(classArray, 1, classArray.length);
                }
                n3 = JavaNativeUtil.getAssignCost(classArray2, method.getParameterTypes());
            } else {
                n3 = JavaNativeUtil.getAssignCost(classArray, method.getParameterTypes());
            }
            if (n3 < 0) continue;
            if (n3 == n2) {
                methodArray2[n++] = method;
                continue;
            }
            if (n3 >= n2) continue;
            n2 = n3;
            methodArray2[0] = method;
            n = 1;
        }
        if (n > 1) {
            Method method = JavaNativeUtil.resolveAmbiguousMethods(classArray, methodArray2, n, bl);
            if (method != null) {
                return method;
            }
            throw new AmbiguousMethodException((Member[])Arrays.copyOf(methodArray2, n), (Class[])classArray);
        }
        return methodArray2[0];
    }

    protected static Method resolveAmbiguousMethods(Class<?>[] classArray, Method[] methodArray, int n, boolean bl) {
        if (classArray.length == 0) {
            return null;
        }
        Method method = methodArray[0];
        Class<?>[] classArray2 = method.getParameterTypes();
        for (int i = 1; i < n; ++i) {
            Method method2 = methodArray[i];
            if (bl && ClassUtil.isStatic(method) != ClassUtil.isStatic(method2)) {
                return null;
            }
            Class<?>[] classArray3 = method2.getParameterTypes();
            int n2 = JavaNativeUtil.getAssignCost(classArray3, classArray2);
            if (n2 == 0) {
                return null;
            }
            if (n2 > 0) {
                method = method2;
                classArray2 = classArray3;
                continue;
            }
            if (JavaNativeUtil.getAssignCost(classArray2, classArray3) > 0) continue;
            return null;
        }
        return method;
    }

    public static Constructor getMatchConstructor(Constructor[] constructorArray, Object[] objectArray) {
        return JavaNativeUtil.getMatchConstructor(constructorArray, JavaNativeUtil.getArgTypes(objectArray));
    }

    public static Constructor getMatchConstructor(Constructor[] constructorArray, Class<?>[] classArray) {
        if (constructorArray == null || constructorArray.length == 0) {
            return null;
        }
        Constructor[] constructorArray2 = new Constructor[constructorArray.length];
        int n = 0;
        int n2 = Integer.MAX_VALUE;
        for (Constructor constructor : constructorArray) {
            int n3 = JavaNativeUtil.getAssignCost(classArray, constructor.getParameterTypes());
            if (n3 < 0) continue;
            if (n3 == n2) {
                constructorArray2[n++] = constructor;
                continue;
            }
            if (n3 >= n2) continue;
            n2 = n3;
            constructorArray2[0] = constructor;
            n = 1;
        }
        if (n > 1) {
            Constructor constructor = JavaNativeUtil.resolveAmbiguousConstructors(classArray, constructorArray2, n);
            if (constructor != null) {
                return constructor;
            }
            throw new AmbiguousMethodException((Member[])Arrays.copyOf(constructorArray2, n), (Class[])classArray);
        }
        return constructorArray2[0];
    }

    protected static Constructor resolveAmbiguousConstructors(Class<?>[] classArray, Constructor[] constructorArray, int n) {
        if (classArray.length == 0) {
            return null;
        }
        Constructor constructor = constructorArray[0];
        Class<?>[] classArray2 = constructor.getParameterTypes();
        for (int i = 1; i < n; ++i) {
            Constructor constructor2 = constructorArray[i];
            Class<?>[] classArray3 = constructor2.getParameterTypes();
            int n2 = JavaNativeUtil.getAssignCost(classArray3, classArray2);
            if (n2 == 0) {
                return null;
            }
            if (n2 > 0) {
                constructor = constructor2;
                classArray2 = classArray3;
                continue;
            }
            if (JavaNativeUtil.getAssignCost(classArray2, classArray3) > 0) continue;
            return null;
        }
        return constructor;
    }

    protected static int getAssignCost(Class<?>[] classArray, Class<?>[] classArray2) {
        if (classArray.length > classArray2.length) {
            return -1;
        }
        int n = (classArray2.length - classArray.length) * 1000000;
        for (int i = 0; i < classArray.length; ++i) {
            int n2 = JavaNativeUtil.getAssignCost(classArray[i], classArray2[i]);
            if (n2 < 0) {
                return -1;
            }
            n += n2;
        }
        return n;
    }

    protected static int getAssignCost(Class<?> clazz, Class<?> clazz2) {
        if (clazz == null) {
            return clazz2.isPrimitive() ? -1 : 1000000;
        }
        if (clazz.equals(clazz2)) {
            return 0;
        }
        if (clazz2.isPrimitive()) {
            return clazz == ClassUtil.getBoxedPrimitiveClass(clazz2) ? 10 : -1;
        }
        if (clazz.isPrimitive()) {
            return clazz2 == ClassUtil.getBoxedPrimitiveClass(clazz) ? 10 : -1;
        }
        if (clazz2.isAssignableFrom(clazz)) {
            return clazz2 == Object.class ? 100 : 1;
        }
        return -1;
    }

    public static Object invokeMethod(Method method, Object[] objectArray) {
        if (ClassUtil.isStatic(method)) {
            return JavaNativeUtil.invokeMethod(method, null, objectArray);
        }
        if (objectArray == null || objectArray.length == 0 || objectArray[0] == null) {
            throw new ScriptRuntimeException("this method need one argument at least");
        }
        Object[] objectArray2 = JavaNativeUtil.prepareArgs(method.getParameterCount(), objectArray, 1);
        return JavaNativeUtil.invokeMethod(method, objectArray[0], objectArray2);
    }

    public static Object[] prepareArgs(int n, Object[] objectArray, int n2) {
        if (objectArray == null) {
            return n == 0 ? ArrayUtil.emptyObjects() : new Object[n];
        }
        if (n2 == 0 && objectArray.length == n) {
            return objectArray;
        }
        Object[] objectArray2 = new Object[n];
        System.arraycopy(objectArray, n2, objectArray2, 0, Math.min(objectArray.length - n2, n));
        return objectArray2;
    }

    public static Object invokeMethod(Method method, Object object, Object[] objectArray) {
        Object[] objectArray2 = JavaNativeUtil.prepareArgs(method.getParameterCount(), objectArray, 0);
        try {
            Object object2 = method.invoke(object, objectArray2);
            return ClassUtil.isVoidType(method.getReturnType()) ? InternalContext.VOID : object2;
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new ScriptRuntimeException("this method is inaccessible: ".concat(illegalAccessException.getLocalizedMessage()), illegalAccessException);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new ScriptRuntimeException("illegal argument: ".concat(illegalArgumentException.getLocalizedMessage()), illegalArgumentException);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new ScriptRuntimeException("this method throws an exception", invocationTargetException);
        }
    }

    public static Object invokeConstructor(Constructor constructor, Object[] objectArray) {
        Object[] objectArray2 = JavaNativeUtil.prepareArgs(constructor.getParameterCount(), objectArray, 0);
        try {
            return constructor.newInstance(objectArray2);
        }
        catch (InstantiationException instantiationException) {
            throw new ScriptRuntimeException("Can't create new instance: ".concat(instantiationException.getLocalizedMessage()), instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new ScriptRuntimeException("Unaccessible method: ".concat(illegalAccessException.getLocalizedMessage()), illegalAccessException);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new ScriptRuntimeException("Illegal arguments: ".concat(illegalArgumentException.getLocalizedMessage()), illegalArgumentException);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new ScriptRuntimeException("this method throws an exception", invocationTargetException);
        }
    }
}

