/*
 * Decompiled with CFR 0.152.
 */
package org.febit.wit.util;

import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;

public class InternedEncoding {
    public static final InternedEncoding UTF_8;
    private static final Map<String, InternedEncoding> INTERNED;
    public final String value;

    private InternedEncoding(String string) {
        this.value = string;
    }

    public static InternedEncoding intern(String string) {
        if (string == null) {
            return null;
        }
        InternedEncoding internedEncoding = INTERNED.get(string = Charset.forName(string).name());
        if (internedEncoding != null) {
            return internedEncoding;
        }
        return InternedEncoding.doIntern(string);
    }

    private static synchronized InternedEncoding doIntern(String string) {
        InternedEncoding internedEncoding = INTERNED.get(string);
        if (internedEncoding != null) {
            return internedEncoding;
        }
        internedEncoding = new InternedEncoding(string);
        INTERNED.put(string, internedEncoding);
        return internedEncoding;
    }

    static {
        INTERNED = new HashMap<String, InternedEncoding>();
        UTF_8 = InternedEncoding.intern("UTF-8");
    }
}

