/*
 * Decompiled with CFR 0.152.
 */
package org.febit.wit.util;

public class FileNameUtil {
    private static final char UNIX_SEPARATOR = '/';
    private static final char WINDOWS_SEPARATOR = '\\';

    private FileNameUtil() {
    }

    private static boolean isSeparator(char c) {
        return c == '/' || c == '\\';
    }

    public static String getPath(String string) {
        if (string == null) {
            return null;
        }
        int n = string.lastIndexOf(47);
        if (n < 0) {
            return "";
        }
        return string.substring(0, n + 1);
    }

    public static String concat(String string, String string2) {
        if (string == null) {
            return null;
        }
        int n = string.length();
        int n2 = FileNameUtil.getPrefixLength(string2);
        if (n2 == 0 && n != 0) {
            if (FileNameUtil.isSeparator(string.charAt(n - 1))) {
                return FileNameUtil.normalize(string.concat(string2));
            }
            return FileNameUtil.normalize(string + '/' + string2);
        }
        if (n2 > 0) {
            return FileNameUtil.normalize(string2);
        }
        return null;
    }

    public static String normalize(String string) {
        int n;
        if (string == null) {
            return null;
        }
        int n2 = string.length();
        if (n2 == 0) {
            return string;
        }
        int n3 = FileNameUtil.getPrefixLength(string);
        if (n3 < 0) {
            return null;
        }
        char[] cArray = new char[n2 + 2];
        string.getChars(0, string.length(), cArray, 0);
        for (n = 0; n < n2; ++n) {
            if (cArray[n] != '\\') continue;
            cArray[n] = 47;
        }
        if (cArray[n2 - 1] != '/') {
            cArray[n2++] = 47;
        }
        for (n = n3 + 1; n < n2; ++n) {
            if (cArray[n] != '/' || cArray[n - 1] != '/') continue;
            System.arraycopy(cArray, n, cArray, n - 1, n2 - n);
            --n2;
            --n;
        }
        for (n = n3 + 1; n < n2; ++n) {
            if (cArray[n] != '/' || cArray[n - 1] != '.' || n != n3 + 1 && cArray[n - 2] != '/') continue;
            System.arraycopy(cArray, n + 1, cArray, n - 1, n2 - n);
            n2 -= 2;
            --n;
        }
        block3: for (n = n3 + 2; n < n2; ++n) {
            if (cArray[n] != '/' || cArray[n - 1] != '.' || cArray[n - 2] != '.' || n != n3 + 2 && cArray[n - 3] != '/') continue;
            if (n == n3 + 2) {
                return null;
            }
            for (int i = n - 4; i >= n3; --i) {
                if (cArray[i] != '/') continue;
                System.arraycopy(cArray, n + 1, cArray, i + 1, n2 - n);
                n2 -= n - i;
                n = i + 1;
                continue block3;
            }
            System.arraycopy(cArray, n + 1, cArray, n3, n2 - n);
            n2 -= n + 1 - n3;
            n = n3 + 1;
        }
        if (n2 <= 0) {
            return "";
        }
        if (n2 <= n3) {
            return new String(cArray, 0, n2);
        }
        return new String(cArray, 0, n2 - 1);
    }

    private static int getPrefixLength(String string) {
        if (string == null) {
            return -1;
        }
        int n = string.length();
        if (n == 0) {
            return 0;
        }
        char c = string.charAt(0);
        if (c == '.') {
            return 0;
        }
        if (c == ':') {
            return -1;
        }
        if (n == 1) {
            if (FileNameUtil.isSeparator(c)) {
                return 1;
            }
            return c == '~' ? 2 : 0;
        }
        char c2 = string.charAt(1);
        if (c == '~') {
            int n2 = string.indexOf(47, 1);
            if (n2 == -1) {
                return n + 1;
            }
            return n2 + 1;
        }
        if (c2 == ':') {
            if (c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z') {
                if (n == 2 || !FileNameUtil.isSeparator(string.charAt(2))) {
                    return 2;
                }
                return 3;
            }
            return -1;
        }
        if (FileNameUtil.isSeparator(c)) {
            if (FileNameUtil.isSeparator(c2)) {
                int n3 = string.indexOf(47, 2);
                int n4 = string.indexOf(92, 2);
                if (n3 == -1 && n4 == -1 || n3 == 2 || n4 == 2) {
                    return -1;
                }
                n3 = n3 == -1 ? n4 : n3;
                n4 = n4 == -1 ? n3 : n4;
                return Math.min(n3, n4) + 1;
            }
            return 1;
        }
        return 0;
    }
}

