/*
 * Decompiled with CFR 0.152.
 */
package org.febit.wit.util;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import org.febit.wit.core.ast.Statement;
import org.febit.wit.exceptions.ScriptRuntimeException;
import org.febit.wit.lang.Iter;
import org.febit.wit.lang.KeyIter;
import org.febit.wit.lang.iter.AbstractArrayIter;
import org.febit.wit.lang.iter.AbstractIter;
import org.febit.wit.lang.iter.MapKeyIter;

public class CollectionUtil {
    private CollectionUtil() {
    }

    public static int getSize(Object object) {
        if (object == null) {
            return 0;
        }
        if (object.getClass().isArray()) {
            return Array.getLength(object);
        }
        if (object instanceof Collection) {
            return ((Collection)object).size();
        }
        if (object instanceof Map) {
            return ((Map)object).size();
        }
        if (object instanceof CharSequence) {
            return ((CharSequence)object).length();
        }
        return -1;
    }

    public static boolean notEmpty(Object object, boolean bl) {
        int n = CollectionUtil.getSize(object);
        if (n == 0) {
            return false;
        }
        if (n > 0) {
            return true;
        }
        if (object instanceof Iterable) {
            return ((Iterable)object).iterator().hasNext();
        }
        if (object instanceof Iterator) {
            return ((Iterator)object).hasNext();
        }
        if (object instanceof Enumeration) {
            return ((Enumeration)object).hasMoreElements();
        }
        return bl;
    }

    public static KeyIter toKeyIter(Object object, Statement statement) {
        if (object == null) {
            return null;
        }
        if (object instanceof Map) {
            return new MapKeyIter((Map)object);
        }
        throw new ScriptRuntimeException("Unsupported type to KeyIter: ".concat(object.getClass().getName()), statement);
    }

    public static Iter toIter(Object object, Statement statement) {
        if (object == null) {
            return null;
        }
        Class<?> clazz = object.getClass();
        if (clazz.isArray()) {
            if (object instanceof Object[]) {
                return CollectionUtil.createIter((Object[])object);
            }
            if (clazz.getComponentType().isPrimitive()) {
                return CollectionUtil.createPrimitiveArrayIter(object);
            }
        } else {
            if (object instanceof Iterable) {
                return CollectionUtil.createIter(((Iterable)object).iterator());
            }
            if (object instanceof Iterator) {
                return CollectionUtil.createIter((Iterator)object);
            }
            if (object instanceof Iter) {
                return (Iter)object;
            }
            if (object instanceof Enumeration) {
                return CollectionUtil.createIter((Enumeration)object);
            }
            if (object instanceof CharSequence) {
                return CollectionUtil.createIter((CharSequence)object);
            }
        }
        throw new ScriptRuntimeException("Unsupported type to Iter: ".concat(object.getClass().getName()), statement);
    }

    private static Iter createIter(final Object[] objectArray) {
        return new AbstractArrayIter(objectArray.length - 1){

            @Override
            public Object next() {
                return objectArray[++this.cursor];
            }
        };
    }

    private static Iter createIter(final Iterator iterator) {
        return new AbstractIter(){

            @Override
            protected Object _next() {
                return iterator.next();
            }

            @Override
            public boolean hasNext() {
                return iterator.hasNext();
            }
        };
    }

    private static Iter createIter(final Enumeration enumeration) {
        return new AbstractIter(){

            @Override
            protected Object _next() {
                return enumeration.nextElement();
            }

            @Override
            public boolean hasNext() {
                return enumeration.hasMoreElements();
            }
        };
    }

    private static Iter createIter(final CharSequence charSequence) {
        return new AbstractArrayIter(charSequence.length() - 1){

            @Override
            public Object next() {
                return Character.valueOf(charSequence.charAt(++this.cursor));
            }
        };
    }

    private static Iter createPrimitiveArrayIter(final Object object) {
        return new AbstractArrayIter(Array.getLength(object) - 1){

            @Override
            public Object next() {
                return Array.get(object, ++this.cursor);
            }
        };
    }

    public static Iter createIntAscIter(final int n, final int n2) {
        if (n > n2) {
            return CollectionUtil.createIntAscIter(n2, n);
        }
        return new Iter(){
            private int current;
            {
                this.current = n - 1;
            }

            @Override
            public boolean hasNext() {
                return this.current < n2;
            }

            @Override
            public Integer next() {
                if (this.current >= n2) {
                    throw new NoSuchElementException("no more next");
                }
                return ++this.current;
            }

            @Override
            public int index() {
                return this.current - n;
            }
        };
    }

    public static Iter createIntDescIter(final int n, final int n2) {
        if (n < n2) {
            return CollectionUtil.createIntDescIter(n2, n);
        }
        return new Iter(){
            private int current;
            {
                this.current = n + 1;
            }

            @Override
            public boolean hasNext() {
                return this.current > n2;
            }

            @Override
            public Integer next() {
                if (this.current <= n2) {
                    throw new NoSuchElementException("no more next");
                }
                return --this.current;
            }

            @Override
            public int index() {
                return n - this.current;
            }
        };
    }
}

