/*
 * Decompiled with CFR 0.152.
 */
package org.febit.wit.util;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.febit.wit.exceptions.UncheckedException;
import org.febit.wit.util.ClassMap;
import org.febit.wit.util.ExceptionUtil;

public class ClassUtil {
    private static final ClassMap<Map<String, Method[]>> PUBLIC_MEMBER_METHODS_CACHE = new ClassMap();

    private ClassUtil() {
    }

    public static String getClassName(Object object) {
        return object != null ? object.getClass().getName() : "null";
    }

    public static Map<String, Field> getSettableMemberFields(Class<?> clazz) {
        HashMap<String, Field> hashMap = new HashMap<String, Field>();
        for (Class<?> clazz2 = clazz; clazz2 != null && clazz2 != Object.class; clazz2 = clazz2.getSuperclass()) {
            for (Field field : clazz2.getDeclaredFields()) {
                int n = field.getModifiers();
                if (Modifier.isStatic(n) || Modifier.isFinal(n) || !Modifier.isPublic(n) && !Modifier.isProtected(n)) continue;
                ClassUtil.setAccessible(field);
                hashMap.put(field.getName(), field);
            }
        }
        return hashMap;
    }

    public static Method[] getPublicMemberMethods(Class<?> clazz, String string) {
        Method[] methodArray;
        Map map = PUBLIC_MEMBER_METHODS_CACHE.get(clazz);
        if (map == null) {
            map = PUBLIC_MEMBER_METHODS_CACHE.putIfAbsent(clazz, new HashMap());
        }
        if ((methodArray = map.get(string)) == null) {
            methodArray = ClassUtil.resolvePublicMemberMethods(clazz, string);
            map.put(string, methodArray);
        }
        return methodArray;
    }

    private static Method[] resolvePublicMemberMethods(Class<?> clazz, String string) {
        AccessibleObject[] accessibleObjectArray = clazz.getMethods();
        HashMap<String, Method> hashMap = new HashMap<String, Method>();
        for (Method method : accessibleObjectArray) {
            if (!ClassUtil.isPublic(method) || ClassUtil.isStatic(method) || !method.getName().equals(string)) continue;
            StringBuilder stringBuilder = new StringBuilder();
            for (Class<?> clazz2 : method.getParameterTypes()) {
                stringBuilder.append(clazz2.getName()).append(',');
            }
            String object = stringBuilder.toString();
            Method method2 = (Method)hashMap.get(object);
            if (method2 != null && !method2.getDeclaringClass().isAssignableFrom(method.getDeclaringClass())) continue;
            hashMap.put(object, method);
        }
        AccessibleObject[] accessibleObjectArray2 = hashMap.values().toArray(new Method[hashMap.size()]);
        ClassUtil.setAccessible((AccessibleObject[])accessibleObjectArray2);
        return accessibleObjectArray2;
    }

    public static Method[] getPublicMethods(Class<?> clazz, String string) {
        AccessibleObject[] accessibleObjectArray = clazz.getMethods();
        HashMap<String, Method> hashMap = new HashMap<String, Method>();
        for (Method method : accessibleObjectArray) {
            if (!ClassUtil.isPublic(method) || !method.getName().equals(string)) continue;
            StringBuilder stringBuilder = new StringBuilder();
            for (Class<?> clazz2 : method.getParameterTypes()) {
                stringBuilder.append(clazz2.getName()).append(',');
            }
            String object = stringBuilder.toString();
            Method method2 = (Method)hashMap.get(object);
            if (method2 != null && !method2.getDeclaringClass().isAssignableFrom(method.getDeclaringClass())) continue;
            hashMap.put(object, method);
        }
        AccessibleObject[] accessibleObjectArray2 = hashMap.values().toArray(new Method[hashMap.size()]);
        ClassUtil.setAccessible((AccessibleObject[])accessibleObjectArray2);
        return accessibleObjectArray2;
    }

    public static ClassLoader getDefaultClassLoader() {
        return Thread.currentThread().getContextClassLoader();
    }

    public static Class<?> getBoxedPrimitiveClass(Class<?> clazz) {
        if (!clazz.isPrimitive()) {
            return null;
        }
        if (clazz == Integer.TYPE) {
            return Integer.class;
        }
        if (clazz == Boolean.TYPE) {
            return Boolean.class;
        }
        if (clazz == Long.TYPE) {
            return Long.class;
        }
        if (clazz == Double.TYPE) {
            return Double.class;
        }
        if (clazz == Float.TYPE) {
            return Float.class;
        }
        if (clazz == Short.TYPE) {
            return Short.class;
        }
        if (clazz == Character.TYPE) {
            return Character.class;
        }
        if (clazz == Byte.TYPE) {
            return Byte.class;
        }
        return Void.class;
    }

    public static char getAliasOfBaseType(String string) {
        switch (string) {
            case "int": {
                return 'I';
            }
            case "long": {
                return 'J';
            }
            case "short": {
                return 'S';
            }
            case "boolean": {
                return 'Z';
            }
            case "char": {
                return 'C';
            }
            case "double": {
                return 'D';
            }
            case "float": {
                return 'F';
            }
            case "byte": {
                return 'B';
            }
            case "void": {
                return 'V';
            }
        }
        return '\u0000';
    }

    public static Class<?> getClass(String string, int n) throws ClassNotFoundException {
        char[] cArray;
        if (n == 0) {
            return ClassUtil.getClass(string);
        }
        char c = ClassUtil.getAliasOfBaseType(string);
        if (c == '\u0000') {
            cArray = new char[string.length() + 2 + n];
            Arrays.fill(cArray, 0, n, '[');
            cArray[n] = 76;
            string.getChars(0, string.length(), cArray, n + 1);
            cArray[cArray.length - 1] = 59;
        } else {
            cArray = new char[n + 1];
            Arrays.fill(cArray, 0, n, '[');
            cArray[n] = c;
        }
        return ClassUtil.getClassByInternalName(new String(cArray));
    }

    public static Class<?> getPrimitiveClass(String string) {
        if (string == null) {
            return null;
        }
        switch (string) {
            case "int": {
                return Integer.TYPE;
            }
            case "long": {
                return Long.TYPE;
            }
            case "short": {
                return Short.TYPE;
            }
            case "boolean": {
                return Boolean.TYPE;
            }
            case "char": {
                return Character.TYPE;
            }
            case "double": {
                return Double.TYPE;
            }
            case "float": {
                return Float.TYPE;
            }
            case "byte": {
                return Byte.TYPE;
            }
            case "void": {
                return Void.TYPE;
            }
        }
        return null;
    }

    public static Class<?> getClass(String string) {
        try {
            Class<?> clazz = ClassUtil.getPrimitiveClass(string);
            return clazz != null ? clazz : ClassUtil.getClassByInternalName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new UncheckedException(classNotFoundException);
        }
    }

    private static Class<?> getClassByInternalName(String string) throws ClassNotFoundException {
        return Class.forName(string, true, ClassUtil.getDefaultClassLoader());
    }

    public static boolean isStatic(Member member) {
        return Modifier.isStatic(member.getModifiers());
    }

    public static boolean isFinal(Member member) {
        return Modifier.isFinal(member.getModifiers());
    }

    public static boolean isPublic(Class<?> clazz) {
        return Modifier.isPublic(clazz.getModifiers());
    }

    public static boolean isPublic(Member member) {
        return Modifier.isPublic(member.getModifiers());
    }

    public static boolean isProtected(Member member) {
        return Modifier.isProtected(member.getModifiers());
    }

    public static boolean isVoidType(Class<?> clazz) {
        return clazz == Void.TYPE || clazz == Void.class;
    }

    public static <T extends AccessibleObject> void setAccessible(T[] TArray) {
        for (T t : TArray) {
            ClassUtil.setAccessible(t);
        }
    }

    public static void setAccessible(AccessibleObject accessibleObject) {
        if (accessibleObject.isAccessible()) {
            return;
        }
        try {
            accessibleObject.setAccessible(true);
        }
        catch (SecurityException securityException) {
            ExceptionUtil.ignore(securityException);
        }
    }

    public static Object newInstance(String string) {
        return ClassUtil.newInstance(ClassUtil.getClass(string));
    }

    public static Object newInstance(Class<?> clazz) {
        try {
            return clazz.newInstance();
        }
        catch (IllegalAccessException | InstantiationException reflectiveOperationException) {
            throw new UncheckedException(reflectiveOperationException);
        }
    }
}

